% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causalDantzig.R
\name{causalDantzig}
\alias{causalDantzig}
\title{Causal Dantzig}
\usage{
causalDantzig(X, Y, ExpInd, regularization = FALSE, alpha = 0.05,
  lambda = NULL, scale = TRUE, mc.cores = 1)
}
\arguments{
\item{X}{A nxp matrix with the predictor variables for all experimental settings, where n is the total number of samples and p ist the number of predictors.}

\item{Y}{The numeric response or target variable of interest of length n.}

\item{ExpInd}{Indicator of the experiment or the intervention type an observation belongs to. A discrete vector of the same length as Y with K unique entries if there are K different experiments (for example entry 1 for all observational data and entry 2 for intervention data).}

\item{regularization}{Use \code{regularization=FALSE} for unregularized causal Dantzig and \code{regulariation=TRUE} for regularized causal Dantzig.}

\item{alpha}{The significance level of the procedure. This parameter is ignored for regularized causal Dantzig. It defaults to \code{alpha=0.05} for two-sided 95\% confidence intervals.}

\item{lambda}{User supplied regularization parameter for regularized causal Dantzig. If \code{lambda=NULL}, then the regularization parameter is chosen by cross-validation. The option \code{lambda=NULL} is experimental.}

\item{scale}{The default \code{scale=TRUE} scales the variables before running regularized causal Dantzig. This parameter is ignored for unregularized causal Dantzig.}

\item{mc.cores}{Number of CPU cores used for cross-validation. Defaults to \code{mc.cores=1}. This parameter is ignored for unregularized causal Dantzig.}
}
\description{
Causal inference in linear structural equation models with hidden variables under additive interventions. This function implements both regularized and unregularized causal Dantzig. For unregularized causal Dantzig, the function returns point estimates and asymptotic confidence intervals. For regularized causal Dantzig, point estimates and a ranking via stability selection are given.
}
\examples{
set.seed(1)
H <- rnorm(2000)
X2 <- H+c(rnorm(1000),rnorm(1000,sd=2))
Y <- X2 + H + rnorm(2000)
X1 <- Y + X2 + c(rnorm(1000),rnorm(1000,sd=2))
X3 <- X1 + H + c(rnorm(1000),rnorm(1000,sd=2))
ExpInd <- c(rep(0,1000),rep(1,1000))

X <- cbind(X1,X2,X3)

fit <- causalDantzig(X,Y,ExpInd,regularization=FALSE)
summary(fit)

fit <- causalDantzig(X,Y,ExpInd,regularization=TRUE)
# for parallel processing:
# mc.cores <- 2
# fit <- causalDantzig(X,Y,ExpInd,regularization=TRUE,mc.cores=mc.cores)
summary(fit)
plot(fit)

}
\references{
Dominik Rothenhausler, Peter Buhlmann, Nicolai Meinshausen (2017):

Causal Dantzig: fast inference in linear structrual equation models with hidden variables under additive interventions

arxiv preprint \url{https://arxiv.org/abs/1706.06159}
}
\seealso{
\code{summary} and \code{plot} methods for "causalDantzig" objects. Furthermore, see \code{ICP} in the package \code{InvariantCausalPrediction} for causal inference in a setting without hidden variables.
}
