% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{diss}
\alias{diss}
\alias{diss.default}
\alias{diss.detritals}
\title{Dissimilarity between detrital age distributions}
\usage{
diss(x, ...)

\method{diss}{default}(x, y, method = "KS", ...)

\method{diss}{detritals}(x, method = "W2", ...)
}
\arguments{
\item{x}{an object of class \code{detrital} OR a vector of numbers}

\item{...}{extra arguments (not used)}

\item{y}{a vector of numbers}

\item{method}{either \code{'KS'} (for Kolmogorov-Smirnov distance),
or \code{'W2'} (for Wasserstein-2 distance).}
}
\value{
an object of class \code{dist}.
}
\description{
Calculates the pairwise dissimilarity between detrital
    age distributions, using either the Wasserstein-2 or
    Kolmogorov-Smirnov distance.
}
\details{
The Kolmogorov-Smirnov statistic is the maximum vertical
    difference between two empirical cumulative distribution
    functions. The Wasserstein distance is a function of the area
    between them. Both dissimilarity measures are useful for
    multidimensional scaling.
}
\examples{
d <- diss(examples$DZ,method='KS')
mds(d)
}
\seealso{
\code{\link{mds}}
}
\author{
Written by Pieter Vermeesch, using modified code from
    Mathieu Vrac's \code{CDFt} package (\code{KolmogorovSmirnov}
    function), and Dominic Schuhmacher's \code{transport} package
    (\code{transport1d} function).
}
