% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getelev.R
\name{getprecip}
\alias{getprecip}
\title{Download rasters of monthly precipitation from internet}
\source{
\url{https://worldclim.org/data/worldclim21.html}
}
\usage{
getprecip(path = NULL, overwrite = FALSE, verbose = interactive())
}
\arguments{
\item{path}{A \emph{string} indicating where to store the file on the hard
drive (without the file name!)}

\item{overwrite}{A \emph{logical} indicating if an existing file should be
re-downloaded}

\item{verbose}{A \emph{logical} indicating whether information about the
progress of the procedure should be displayed or not while the function is
running. By default verbose is \code{TRUE} if users use an interactive R
session and \code{FALSE} otherwise. If a \emph{numeric} is provided instead,
additional information about the download will be provided if the number is
greater than 1.}
}
\description{
The function \code{getprecip} allows for the download of rasters of monthly
precipitation from internet. It downloads the "precipitation (mm) WorldClim
Version 2.1" at a spatial resolution of 30 seconds (~1 km2). After download,
the function also unzip the file. The function \code{getprecip} uses the
generic function \code{downloadfile} that can also be used to download
directly other files. This raster needs further processing with the function
\link{prepcipitate}. It can then be used to predict annual averages
precipitation weighted isoscapes with the function
\link{isomultiscape}.
}
\details{
In the argument "path" is not provided, the file will be stored in the
current working directory. The functions can create new directories, so you
can also indicate a new path. The integrity of the elevation raster is tested
after a call to \code{getprecip}. In case of corruption, try downloading the
file again, specifying overwrite = TRUE to overwrite the corrupted file.
}
\examples{

## To download the monthly precipitation
## in your current working
## directory, just type:
## getprecip()
## Mind that the file weights ca. 1GB!
}
