% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmo.R
\name{jmo}
\alias{jmo}
\title{Joint Modelling for Ordinal outcomes}
\usage{
jmo(
  p,
  s,
  yfile,
  cfile,
  mfile,
  point = 20,
  maxiterations = 1e+05,
  do.trace = FALSE,
  type_file = TRUE
)
}
\arguments{
\item{p}{The dimension of proportional odds covariates (not including intercept) in yfile.}

\item{s}{The dimension of non-proportional odds covariates in yfile.}

\item{yfile}{Y matrix for longitudinal measurements in long format. For example, for a subject with n measurements, there are n rows for this subject. The # of rows in y matrix is the total number of measurements for all subjects. The columns in Y are ordered this way: the longitudinal outcome (column 1), then the covariates for random effects, and lastly, the covariates for fixed effects (no intercept).}

\item{cfile}{C matrix for competing risks failure time data. Each subject has one data entry, so the number of rows equals to the number of subjects. The survival / censoring time is included in the first column, and the failure type coded as 0 (censored events), 1 (risk 1), or 2 (risk 2) is given in the second column. Two competing risks are assumed. The covariates are included in the third column and on.}

\item{mfile}{M vector to indicate the number of longitudinal measurements per subject. The number of rows equals to the number of subjects.}

\item{point}{Quadrature points used in the EM procedure. Default is 20.}

\item{maxiterations}{Maximum values of iterations. Default is 100000.}

\item{do.trace}{Print detailed information of each iteration. Default is false, not to print the iteration details.}

\item{type_file}{Types of inputs. Default is true, i.e.  data files with headers. If set to "F", inputs are changed to data matrixes or data.frames (with headers)}
}
\value{
Object of class \code{JMcmprsk} with elements
  \tabular{ll}{
      \code{vcmatrix}    \tab  The variance-covariance matrix for all the parameters. The parameters are in the order: \eqn{\beta}, \eqn{\alpha}, \eqn{\theta}, \eqn{\gamma}, \eqn{\nu}, and \eqn{\Sigma}. The elements in \eqn{\Sigma} are output in the order along the main diagonal line, then the second main diagonal line, and so on. \cr
      \code{betas} \tab The point  estimates of \eqn{\beta}. \cr
      \code{se_betas} \tab The standard error estimate of \eqn{\beta}. \cr
      \code{alphamatrix} \tab The point  estimates of \eqn{\alpha}. \cr
      \code{se_alphas} \tab The standard error estimate of \eqn{\alpha}. \cr
      \code{theta} \tab The point  estimates of \eqn{\theta}. \cr 
      \code{se_theta} \tab The standard error estimate of \eqn{\theta}. \cr
      \code{gamma_matrix} \tab  The point  estimate of \eqn{\gamma}. \cr
      \code{se_gamma_matrix}   \tab  The standard error estimate of \eqn{\gamma}. \cr
      \code{v_estimate} \tab The point  estimate of \eqn{\nu}. \cr
      \code{se_v_estimate}    \tab The standard error estimate of \eqn{\nu}. \cr
      \code{sigma_matrix}     \tab The point estimate of \eqn{\Sigma} (only the upper triangle portion of the matrix is output).\cr
      \code{se_sigma}     \tab The standard error estimate of \eqn{\Sigma}.The standard errors are given in this order: main diagonal, the second main diagonal, and so on. \cr
      \code{loglike}     \tab Log Likelihood.\cr
  }
}
\description{
Joint modeling of longitudinal ordinal data and competing risks
}
\examples{
# A toy example on simulated data
 require(JMcmprsk)
 set.seed(123)
 yfile=system.file("extdata", "jmosimy.txt", package = "JMcmprsk")
 cfile=system.file("extdata", "jmosimc.txt", package = "JMcmprsk")
 mfile=system.file("extdata", "jmosimm.txt", package = "JMcmprsk")
 res3=jmo(p=3,s=1, yfile,cfile,mfile,point=6)
 coef(res3)
#testing the function on real data with trace on
\donttest{
require(JMcmprsk)
set.seed(123)
yfile=system.file("extdata", "ninds_nrank_y.txt", package = "JMcmprsk")
cfile=system.file("extdata", "ninds_nrank_c.txt", package = "JMcmprsk")
mfile=system.file("extdata", "ninds_nrank_m.txt", package = "JMcmprsk")
res=jmo(p=9,s=2, yfile,cfile,mfile,point=6,do.trace = TRUE)
#if the input are not files but matrixes or data.frames,i.e. type_file=F
ydata=read.table(yfile,header = T)
cdata=read.table(cfile,header = T)
mdata=read.table(mfile)
res=jmo(p=9,s=2, ydata,cdata,mdata,point=6,do.trace = TRUE,type_file = F)
coef(res)
anova(res,coeff="beta")
anova(res,coeff="gamma")
anova(res,coeff="alpha")
}
}
\references{
\itemize{
\item Ning Li,Robert M. Elashoff,Gang Li and Jeffrey Saver. "Joint modeling of longitudinal ordinal data and competing risks survival times and analysis of the NINDS rt-PA stroke trial." Statistics in medicine 29.5 (2010): 546-557.
}
}
\seealso{
\code{\link{jmc}}
}
