% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_support.R
\name{predict.ps2dsignal}
\alias{predict.ps2dsignal}
\title{Predict function for \code{ps2DSignal}}
\usage{
\method{predict}{ps2dsignal}(object, ..., M_pred, M_type = "unfolded", type = "mu")
}
\arguments{
\item{object}{an object using \code{ps2DSignal}.}

\item{...}{other parameters.}

\item{M_pred}{a matrix of \code{q} arbitrary "stacked" or "unfolded" signal matrices
of dimension (\code{q} by \code{p1}) by \code{p2} or \code{q} by (\code{p1}
by \code{p2}, respectively,
for desired prediction (default "unfolded").}

\item{M_type}{"stacked" or "unfolded" (default).}

\item{type}{the mean value \code{type = "mu"} (default) or linear predictor
\code{type = "eta"}.}
}
\value{
\item{pred}{the estimated mean (inverse link function)
or the linear predictor prediction with \code{type =
"eta"}, for arbitary 2D signals in \code{M_pred}.}
}
\description{
Prediction function which returns both linear
predictor and inverse link predictions for arbitrary 2D signals (using
\code{ps2DSignal} with \code{class ps2dsignal}).
}
\examples{
library(fields)
library(JOPS)

# Get the data
x0 <- Sugar$X
x0 <- x0 - apply(x0, 1, mean) # center Signal
y <- as.vector(Sugar$y[, 3]) # Response is Ash

# Inputs for two-dimensional signal regression
nseg <- c(7, 37)
pord <- c(3, 3)
min_ <- c(230, 275)
max_ <- c(340, 560)
M1_index <- rev(c(340, 325, 305, 290, 255, 240, 230))
M2_index <- seq(from = 275, to = 560, by = .5)
p1 <- length(M1_index)
p2 <- length(M2_index)

# Fit optimal model based on LOOCV
opt_lam <- c(8858.6679, 428.1332) # Found via svcm
Pars_opt <- rbind(
  c(min_[1], max_[1], nseg[1], 3, opt_lam[1], pord[1]),
  c(min_[2], max_[2], nseg[2], 3, opt_lam[2], pord[2])
)
fit <- ps2DSignal(y, x0, p1, p2, "unfolded", M1_index, M2_index,
  Pars_opt,int = TRUE, ridge_adj = 0.0001,
  M_pred = x0 )


predict(fit, M_pred= x0, type = "mu", M_type = "unfolded")
}
\references{
Marx, B.D. and Eilers, P.H.C. (2005).
Multidimensional penalized signal regression, \emph{Technometrics}, 47: 13-22.

Eilers, P.H.C. and Marx, B.D. (2021). \emph{Practical Smoothing, The Joys of
P-splines.} Cambridge University Press.
}
\author{
Paul Eilers and Brian Marx
}
