% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/styler.R
\name{param_summary_format}
\alias{param_summary_format}
\title{Format a data frame of summary statistics}
\usage{
param_summary_format(d, digits = getOption("digits"), pretty = FALSE)
}
\arguments{
\item{d}{A data frame of the parameter summary statistics}

\item{digits}{Number of digits to round to for printing}

\item{pretty}{Logical value whether prettified values should be returned.
Defaults to \code{FALSE}.}
}
\value{
A formatted data frame of summary statistics or a formated
vector (if \code{pretty = TRUE}).
}
\description{
This functions nicely formats a data frame of parameter summary
statistics and is designed to be used with the param_summary()
function.
}
\examples{
set.seed(1234)
xsum <- do.call(rbind, apply(matrix(rnorm(100*10), ncol = 10),
  2, param_summary))
rownames(xsum) <- letters[1:10]
param_summary_format(xsum)
param_summary_format(xsum, pretty = TRUE)

rm(xsum)
}
\author{
Joshua F. Wiley <josh@elkhartgroup.com>
}
\keyword{utilities}

