/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.GUI;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.omegahat.Environment.GUI.EvaluatorJPanel;
import org.omegahat.Environment.IO.InputConsumer;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Interpreter.InteractiveEvaluator;
import org.omegahat.Environment.Interpreter.Options;

public class UserInput
extends EvaluatorJPanel
implements ActionListener,
Action {
    protected JTextPane editor = null;
    protected SimpleAttributeSet promptAttrs = null;
    protected SimpleAttributeSet inputAttrs = null;
    protected DefaultStyledDocument doc = null;
    protected ImageIcon icon = null;
    protected String currentPrompt;

    public UserInput(Evaluator evaluator) {
        super(evaluator);
        this.make();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            int n = 2;
            if (this.currentPrompt != null) {
                n = this.currentPrompt.length();
            }
            String string = this.editor.getText(n, this.editor.getText().length() - n);
            boolean bl = ((InputConsumer)((Object)this.evaluator())).inputReady(string);
            if (bl) {
                this.resetInput();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addListener() {
        Keymap keymap = this.editor.getKeymap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, true);
        keymap.addActionForKeyStroke(keyStroke, this);
        this.editor.setKeymap(keymap);
    }

    public boolean createDisplayAttributes() {
        this.promptAttrs = new SimpleAttributeSet();
        StyleConstants.setForeground(this.promptAttrs, Color.red);
        StyleConstants.setFontSize(this.promptAttrs, 12);
        this.inputAttrs = new SimpleAttributeSet();
        StyleConstants.setForeground(this.inputAttrs, Color.blue);
        StyleConstants.setFontSize(this.inputAttrs, 12);
        return true;
    }

    public Object getValue(String string) {
        System.err.println("In getValue()");
        return null;
    }

    public boolean make() {
        this.doc = new DefaultStyledDocument();
        this.editor = new JTextPane(this.doc);
        this.add("Center", this.editor);
        this.icon = new ImageIcon(String.valueOf(System.getProperty("OMEGA_HOME")) + "/Environment/Images/" + "Omega.gif");
        this.addListener();
        return true;
    }

    public boolean prompt() {
        if (this.promptAttrs == null) {
            this.createDisplayAttributes();
        }
        String string = Options.DefaultPrompt;
        if (this.evaluator() != null) {
            string = this.evaluator() instanceof InteractiveEvaluator ? ((InteractiveEvaluator)this.evaluator()).prompt() : this.evaluator().options().prompt();
        }
        this.currentPrompt = string;
        this.editor.setText("");
        try {
            this.editor.insertIcon(this.icon);
            this.doc.insertString(1, string, this.promptAttrs);
            this.editor.setCharacterAttributes(this.inputAttrs, true);
        }
        catch (Exception exception) {}
        return true;
    }

    public void putValue(String string, Object object) {
    }

    boolean resetInput() {
        this.prompt();
        return false;
    }
}

