/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.System;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omegahat.Environment.Utils.OrderedTable;

public class UserClassLoader
extends ClassLoader {
    protected ClassLoader parent;
    protected OrderedTable containers = new OrderedTable(5);
    protected Hashtable classes = new Hashtable(10);

    public UserClassLoader() {
    }

    public UserClassLoader(File file) {
        this();
        this.add(file);
    }

    public UserClassLoader(ClassLoader classLoader) {
        this.parent(classLoader);
    }

    public Object Import(String string) {
        int n = string.indexOf(42);
        if (n < 0) {
            return this.add(string);
        }
        int n2 = 0;
        while (n > 0) {
            if (string.charAt(n - 1) == '.') {
                String string2 = string.substring(0, n - 1);
                this.add(string2.replace('.', '/'));
                ++n2;
            }
            n = string.indexOf(42, n + 1);
        }
        return new Integer(n2);
    }

    public Object add(File file) {
        return this.containers().put(file.toString(), file);
    }

    public Object add(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            return this.add(file);
        }
        return null;
    }

    public Hashtable classes() {
        return this.classes;
    }

    public Hashtable classes(Hashtable hashtable) {
        this.classes = hashtable;
        return this.classes();
    }

    public OrderedTable containers() {
        return this.containers;
    }

    public OrderedTable containers(OrderedTable orderedTable) {
        this.containers = orderedTable;
        return this.containers();
    }

    protected Class defineClass(String string) {
        Class clazz = null;
        String string2 = string.replace('.', '/');
        byte[] byArray = null;
        Enumeration enumeration = this.containers().ordered().elements();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            Object e = enumeration.nextElement();
            if (e instanceof File && ((File)e).isDirectory()) {
                serializable = new File(String.valueOf(String.valueOf((File)e)) + "/" + string2 + ".class");
                try {
                    FileInputStream fileInputStream = new FileInputStream((File)serializable);
                    byArray = this.readBytes(fileInputStream);
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                    return null;
                }
            }
            if (!(e instanceof URL)) continue;
            serializable = (URL)e;
        }
        clazz = this.defineClass(string, byArray);
        return clazz;
    }

    public Class defineClass(String string, byte[] byArray) {
        Class<?> clazz = null;
        if (byArray != null) {
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            if (clazz != null) {
                this.resolveClass(clazz);
            }
            this.classes().put(string, clazz);
        }
        return clazz;
    }

    public Class loadClass(String string) {
        return this.loadClass(string, true);
    }

    public Class loadClass(String string, boolean bl) {
        Class clazz = null;
        clazz = (Class)this.classes().get(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (clazz == null) {
            clazz = this.defineClass(string);
        }
        return clazz;
    }

    public ClassLoader parent() {
        return this.parent;
    }

    public ClassLoader parent(ClassLoader classLoader) {
        this.parent = classLoader;
        return this.parent();
    }

    public byte[] readBytes(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        while (!bl) {
            try {
                int n = inputStream.read();
                if (n == -1) {
                    bl = true;
                    continue;
                }
                byteArrayOutputStream.write(n);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }
}

