/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Block;
import com.sun.java.help.search.BlockFactory;
import com.sun.java.help.search.BlockManagerParameters;
import com.sun.java.help.search.BlockProcessor;
import com.sun.java.help.search.RAFFile;
import com.sun.java.help.search.RAFFileFactory;
import java.io.IOException;

class BlockManager {
    private static RAFFileFactory factory = RAFFileFactory.create();
    private RAFFile file;
    private long blockSize;
    private boolean update;
    private final int nBlocksLimit = 64;
    private int blockTableSize;
    private BlockDescriptor[] blockTab;
    private int nBlocks = 0;
    private int oldest = 0;
    private int newest = 0;
    private BlockFactory bfactory = null;
    private static final int INCR = 256;
    private Block dummy;
    private boolean debug = false;

    public BlockManager(BlockManagerParameters blockManagerParameters, boolean bl, BlockFactory blockFactory) throws IOException {
        this.bfactory = blockFactory;
        this.update = bl;
        this.blockSize = blockManagerParameters.getBlockSize();
        this.debug(blockManagerParameters.getURL().toString());
        this.file = factory.get(blockManagerParameters.getURL(), bl);
        this.debug(this.file.toString());
        this.dummy = blockFactory.makeBlock();
        if (this.file.length() == 0L && bl) {
            this.dummy.setBlockNumber(0);
            this.writeBlock(this.dummy);
        }
        this.blockTableSize = (int)(this.file.length() / this.blockSize);
        this.blockTab = new BlockDescriptor[this.blockTableSize];
        this.mapBlock(0, new BlockDescriptor(), blockFactory.makeBlock());
    }

    public Block accessBlock(int n) throws Exception {
        if (this.blockTab[n] != null) {
            this.moveToFront(n);
        } else if (this.nBlocks < 64) {
            this.mapBlock(n, new BlockDescriptor(), this.bfactory.makeBlock());
        } else {
            this.remapSomeBlock(n);
        }
        return this.blockTab[n].block;
    }

    private void addDescriptor(Block block, int n, BlockDescriptor blockDescriptor) {
        this.blockTab[n] = blockDescriptor;
        blockDescriptor.block = block;
        blockDescriptor.prev = this.newest;
        this.blockTab[this.newest].next = n;
        this.newest = n;
        ++this.nBlocks;
    }

    public void close() throws IOException {
        if (this.update) {
            int n = 0;
            while (n < this.blockTableSize) {
                if (this.blockTab[n] != null && this.blockTab[n].modf) {
                    this.writeBlock(this.blockTab[n].block);
                }
                ++n;
            }
        }
        this.file.close();
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("Block Manager: " + string);
        }
    }

    public Block getNewBlock() throws Exception {
        Object object;
        int n = (int)(this.file.length() / this.blockSize);
        if (n > this.blockTableSize - 1) {
            object = new BlockDescriptor[this.blockTableSize + 256];
            System.arraycopy(this.blockTab, 0, object, 0, this.blockTableSize);
            this.blockTab = object;
            this.blockTableSize += 256;
        }
        if (this.nBlocks < 64) {
            object = this.bfactory.makeBlock();
            ((Block)object).setBlockNumber(n);
            this.writeBlock((Block)object);
            this.addDescriptor((Block)object, n, new BlockDescriptor());
        } else {
            this.dummy.setBlockNumber(n);
            this.writeBlock(this.dummy);
            this.remapSomeBlock(n);
        }
        return this.blockTab[n].block;
    }

    public void lockBlock(int n) {
        this.blockTab[n].lock = true;
    }

    private void mapBlock(int n, BlockDescriptor blockDescriptor, Block block) throws IOException {
        this.file.seek(this.blockSize * (long)n);
        Block.readIn(this.file, block);
        this.addDescriptor(block, n, blockDescriptor);
    }

    public void mapBlocks(BlockProcessor blockProcessor) throws IOException {
        long l = this.file.length() / this.blockSize;
        Block block = this.bfactory.makeBlock();
        this.file.seek(0L);
        int n = 0;
        while ((long)n < l) {
            blockProcessor.process(Block.readIn(this.file, block));
            ++n;
        }
    }

    private void moveToFront(int n) {
        if (n == this.oldest) {
            this.oldest = this.blockTab[n].next;
            this.blockTab[n].prev = this.newest;
            this.blockTab[this.newest].next = n;
            this.newest = n;
        } else if (n != this.newest) {
            this.blockTab[this.blockTab[n].next].prev = this.blockTab[n].prev;
            this.blockTab[this.blockTab[n].prev].next = this.blockTab[n].next;
            this.blockTab[n].prev = this.newest;
            this.blockTab[this.newest].next = n;
            this.newest = n;
        }
    }

    private void remapSomeBlock(int n) throws Exception {
        int n2 = this.oldest;
        while (this.blockTab[n2].lock && n2 != this.newest) {
            n2 = this.blockTab[n2].next;
        }
        if (this.blockTab[n2].lock) {
            throw new Exception("everything locked");
        }
        if (this.blockTab[n2].modf) {
            this.writeBlock(this.blockTab[n2].block);
        }
        --this.nBlocks;
        Block block = this.blockTab[n2].block;
        if (n2 == this.oldest) {
            this.oldest = this.blockTab[n2].next;
        } else if (n2 == this.newest) {
            this.newest = this.blockTab[n2].prev;
        } else {
            this.blockTab[this.blockTab[n2].next].prev = this.blockTab[n2].prev;
            this.blockTab[this.blockTab[n2].prev].next = this.blockTab[n2].next;
        }
        this.blockTab[n2].reset();
        this.mapBlock(n, this.blockTab[n2], block);
        this.blockTab[n2] = null;
    }

    public void setModified(int n) {
        this.blockTab[n].modf = true;
    }

    public void unlockBlock(int n) {
        this.blockTab[n].lock = false;
    }

    public void writeBlock(Block block) throws IOException {
        this.file.seek(this.blockSize * (long)block.number);
        block.writeOut(this.file);
    }

    private class BlockDescriptor {
        public Block block = null;
        public boolean lock = false;
        public boolean modf = false;
        public int prev = 0;
        public int next = 0;

        BlockDescriptor() {
        }

        public void reset() {
            this.modf = false;
            this.lock = false;
            this.block = null;
        }
    }
}

