/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.help.DefaultHelpModel;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpSearchNavigator;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.TextHelpModel;
import javax.help.plaf.HelpNavigatorUI;
import javax.help.plaf.basic.BasicHelpUI;
import javax.help.plaf.basic.BasicSearchCellRenderer;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.RepaintManager;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicSearchNavigatorUI
extends HelpNavigatorUI
implements SearchListener,
PropertyChangeListener,
TreeSelectionListener {
    protected JHelpSearchNavigator searchnav;
    protected JScrollPane sp;
    protected JTree tree;
    protected DefaultMutableTreeNode topNode;
    protected JTextField searchparams;
    protected boolean displayOptions;
    protected SearchEngine helpsearch;
    protected SearchQuery searchquery;
    protected DefaultMutableTreeNode lastTOCnode;
    ActionListener searchAction = new SearchActionListener();
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$help$plaf$basic$BasicSearchNavigatorUI;

    public BasicSearchNavigatorUI(JHelpSearchNavigator jHelpSearchNavigator) {
        this.setIcon(BasicHelpUI.getIcon(class$javax$help$plaf$basic$BasicSearchNavigatorUI != null ? class$javax$help$plaf$basic$BasicSearchNavigatorUI : (class$javax$help$plaf$basic$BasicSearchNavigatorUI = BasicSearchNavigatorUI.class$("javax.help.plaf.basic.BasicSearchNavigatorUI")), "images/search.gif"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSearchNavigatorUI((JHelpSearchNavigator)jComponent);
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println("BasicSearchNavigatorUI: " + string);
        }
    }

    private DefaultMutableTreeNode findIDorURL(DefaultMutableTreeNode defaultMutableTreeNode, Map.ID iD, URL uRL) {
        SearchTOCItem searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
        if (searchTOCItem != null) {
            Map.ID iD2 = searchTOCItem.getID();
            if (iD2 != null && iD != null && iD2.equals(iD)) {
                return defaultMutableTreeNode;
            }
            URL uRL2 = searchTOCItem.getURL();
            if (uRL2 != null && uRL != null && uRL.sameFile(uRL2)) {
                return defaultMutableTreeNode;
            }
        }
        int n = defaultMutableTreeNode.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = this.findIDorURL(defaultMutableTreeNode2, iD, uRL);
            if (defaultMutableTreeNode3 != null) {
                return defaultMutableTreeNode3;
            }
            ++n2;
        }
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.sp != null) {
            return ((ScrollPaneLayout)this.sp.getLayout()).minimumLayoutSize(this.sp);
        }
        return new Dimension(100, 100);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return new Dimension(200, 100);
    }

    public void installUI(JComponent jComponent) {
        this.searchnav = (JHelpSearchNavigator)jComponent;
        HelpModel helpModel = this.searchnav.getModel();
        this.searchnav.setLayout(new BorderLayout());
        this.searchnav.addPropertyChangeListener(this);
        JLabel jLabel = new JLabel(HelpUtilities.getString(HelpUtilities.getLocale(jComponent), "search.findLabel"));
        this.searchparams = new JTextField("", 20);
        this.searchparams.addActionListener(this.searchAction);
        Box box = Box.createHorizontalBox();
        box.add(jLabel);
        box.add(this.searchparams);
        this.searchnav.add("North", box);
        this.topNode = new DefaultMutableTreeNode();
        this.lastTOCnode = null;
        this.tree = new JTree(this.topNode);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.addTreeSelectionListener(this);
        this.tree.setShowsRootHandles(false);
        this.tree.setRootVisible(false);
        this.sp = new JScrollPane();
        this.sp.getViewport().add(this.tree);
        this.searchnav.add("Center", this.sp);
        this.reloadData();
    }

    public void itemsFound(SearchEvent searchEvent) {
        BasicSearchNavigatorUI.debug("items found");
        HelpModel helpModel = this.searchnav.getModel();
        HelpSet helpSet = helpModel.getHelpSet();
        Map map = helpSet.getCombinedMap();
        Enumeration enumeration = searchEvent.getSearchItems();
        while (enumeration.hasMoreElements()) {
            SearchTOCItem searchTOCItem;
            URL uRL;
            SearchItem searchItem = (SearchItem)enumeration.nextElement();
            BasicSearchNavigatorUI.debug("  item: " + searchItem);
            try {
                uRL = new URL(searchItem.getBase(), searchItem.getFilename());
            }
            catch (MalformedURLException malformedURLException) {
                continue;
            }
            Map.ID iD = map.getIDFromURL(uRL);
            DefaultMutableTreeNode defaultMutableTreeNode = this.findIDorURL(this.topNode, iD, uRL);
            if (defaultMutableTreeNode == null) {
                searchTOCItem = new SearchTOCItem(searchItem);
                defaultMutableTreeNode = new DefaultMutableTreeNode(searchTOCItem);
            } else {
                searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
                searchTOCItem.addSearchHit(new SearchHit(searchItem.getConfidence(), searchItem.getBegin(), searchItem.getEnd()));
            }
            this.reorder(defaultMutableTreeNode);
        }
        ((DefaultTreeModel)this.tree.getModel()).reload();
    }

    public void merge(NavigatorView navigatorView) {
        BasicSearchNavigatorUI.debug("merging " + navigatorView);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        BasicSearchNavigatorUI.debug(String.valueOf(String.valueOf(this)) + " " + "propertyChange: " + propertyChangeEvent.getSource() + " " + propertyChangeEvent.getPropertyName());
        if (propertyChangeEvent.getSource() == this.searchnav) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("helpModel")) {
                this.reloadData();
            } else if (string.equals("font")) {
                BasicSearchNavigatorUI.debug("Font change");
                Font font = (Font)propertyChangeEvent.getNewValue();
                this.tree.setFont(font);
                RepaintManager.currentManager(this.tree).markCompletelyDirty(this.tree);
            }
        }
    }

    public void reloadData() {
        this.helpsearch = null;
        this.setCellRenderer(this.searchnav.getNavigatorView(), this.tree);
    }

    public void remove(NavigatorView navigatorView) {
        BasicSearchNavigatorUI.debug("removing " + navigatorView);
    }

    private void reorder(DefaultMutableTreeNode defaultMutableTreeNode) {
        int n;
        double d;
        SearchTOCItem searchTOCItem;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        BasicSearchNavigatorUI.debug("reorder node=" + defaultMutableTreeNode);
        if (this.topNode.getChildCount() == 0) {
            this.topNode.insert(defaultMutableTreeNode, 0);
            return;
        }
        SearchTOCItem searchTOCItem2 = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
        if (searchTOCItem2.inTOC()) {
            return;
        }
        double d2 = searchTOCItem2.getConfidence();
        int n2 = searchTOCItem2.hitCount();
        BasicSearchNavigatorUI.debug("confidence=" + d2 + " hits=" + n2);
        boolean bl = false;
        boolean bl2 = false;
        if (defaultMutableTreeNode.getParent() != null) {
            defaultMutableTreeNode2 = defaultMutableTreeNode.getPreviousSibling();
            if (defaultMutableTreeNode2 != null && defaultMutableTreeNode2 != this.lastTOCnode) {
                searchTOCItem = (SearchTOCItem)defaultMutableTreeNode2.getUserObject();
                d = searchTOCItem.getConfidence();
                n = searchTOCItem.hitCount();
                if (d < d2) {
                    bl = true;
                    BasicSearchNavigatorUI.debug("lower test confidence=" + d + " hits=" + n2);
                } else if (d == d2 && n >= n2) {
                    BasicSearchNavigatorUI.debug("lower test confidence=" + d + " hits=" + n2);
                    bl = true;
                }
            } else {
                BasicSearchNavigatorUI.debug("no lower ok");
                bl = true;
            }
            defaultMutableTreeNode2 = defaultMutableTreeNode.getNextSibling();
            if (defaultMutableTreeNode2 != null) {
                searchTOCItem = (SearchTOCItem)defaultMutableTreeNode2.getUserObject();
                d = searchTOCItem.getConfidence();
                n = searchTOCItem.hitCount();
                if (d > d2) {
                    BasicSearchNavigatorUI.debug("upper test confidence=" + d + " hits=" + n2);
                    bl2 = true;
                } else if (d == d2 && n <= n2) {
                    BasicSearchNavigatorUI.debug("upper test confidence=" + d + " hits=" + n2);
                    bl2 = true;
                }
            } else {
                BasicSearchNavigatorUI.debug("upper doesn't exist");
                bl2 = true;
            }
            if (bl && bl2) {
                BasicSearchNavigatorUI.debug("lower & upper ok");
                return;
            }
        }
        if (defaultMutableTreeNode.getParent() != null) {
            ((DefaultMutableTreeNode)defaultMutableTreeNode.getParent()).remove(defaultMutableTreeNode);
        }
        defaultMutableTreeNode2 = this.lastTOCnode != null ? this.lastTOCnode.getNextSibling() : (DefaultMutableTreeNode)this.topNode.getFirstChild();
        do {
            searchTOCItem = (SearchTOCItem)defaultMutableTreeNode2.getUserObject();
            d = searchTOCItem.getConfidence();
            n = searchTOCItem.hitCount();
            if (d < d2) {
                defaultMutableTreeNode2 = defaultMutableTreeNode2.getNextSibling();
                continue;
            }
            if (d == d2 && n >= n2) {
                defaultMutableTreeNode2 = defaultMutableTreeNode2.getNextSibling();
                continue;
            }
            BasicSearchNavigatorUI.debug("test confidence=" + d + " hits=" + n2);
            break;
        } while (defaultMutableTreeNode2 != null);
        int n3 = defaultMutableTreeNode2 != null ? defaultMutableTreeNode2.getParent().getIndex(defaultMutableTreeNode2) : this.topNode.getChildCount();
        BasicSearchNavigatorUI.debug("inserting at " + n3);
        this.topNode.insert(defaultMutableTreeNode, n3);
    }

    public void searchFinished(SearchEvent searchEvent) {
        BasicSearchNavigatorUI.debug("search Finished");
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        if (this.lastTOCnode == null && this.topNode.getChildCount() > 0) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.topNode.getFirstChild();
            if (defaultMutableTreeNode != null) {
                treeSelectionModel.clearSelection();
                treeSelectionModel.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
            }
        } else {
            this.searchnav.getToolkit().beep();
        }
    }

    public void searchStarted(SearchEvent searchEvent) {
        BasicSearchNavigatorUI.debug("search Started");
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.clearSelection();
        this.topNode.removeAllChildren();
        ((DefaultTreeModel)this.tree.getModel()).reload();
        this.tree.invalidate();
        this.tree.repaint();
    }

    protected void setCellRenderer(NavigatorView navigatorView, JTree jTree) {
        if (navigatorView == null) {
            return;
        }
        Map map = navigatorView.getHelpSet().getCombinedMap();
        jTree.setCellRenderer(new BasicSearchCellRenderer(map));
    }

    public void uninstallUI(JComponent jComponent) {
        HelpModel helpModel = this.searchnav.getModel();
        this.searchnav.removePropertyChangeListener(this);
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        treeSelectionModel.removeTreeSelectionListener(this);
        this.searchnav.setLayout(null);
        this.searchnav.removeAll();
        this.searchnav = null;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        BasicSearchNavigatorUI.debug("ValueChanged: " + treeSelectionEvent);
        BasicSearchNavigatorUI.debug("  model: " + this.searchnav.getModel());
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        SearchTOCItem searchTOCItem = (SearchTOCItem)defaultMutableTreeNode.getUserObject();
        BasicSearchNavigatorUI.debug("item:" + searchTOCItem.getURL());
        if (searchTOCItem != null) {
            HelpModel helpModel = this.searchnav.getModel();
            HelpSet helpSet = helpModel.getHelpSet();
            if (searchTOCItem.getID() != null) {
                try {
                    helpModel.setCurrentID(searchTOCItem.getID());
                }
                catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                    BasicSearchNavigatorUI.debug(String.valueOf(String.valueOf(this)) + " " + "BadID");
                    return;
                }
            } else if (searchTOCItem.getURL() != null) {
                helpModel.setCurrentURL(searchTOCItem.getURL());
            } else {
                return;
            }
            if (helpModel instanceof TextHelpModel) {
                TextHelpModel textHelpModel = (TextHelpModel)helpModel;
                TextHelpModel.Highlight[] highlightArray = new DefaultHelpModel.DefaultHighlight[searchTOCItem.hitCount()];
                int n = 0;
                Enumeration enumeration = searchTOCItem.getSearchHits();
                while (enumeration.hasMoreElements()) {
                    SearchHit searchHit = (SearchHit)enumeration.nextElement();
                    highlightArray[n] = new DefaultHelpModel.DefaultHighlight(searchHit.getBegin(), searchHit.getEnd());
                    ++n;
                }
                textHelpModel.setHighlights(highlightArray);
            }
        }
    }

    class SearchActionListener
    implements ActionListener {
        SearchActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpModel helpModel = BasicSearchNavigatorUI.this.searchnav.getModel();
            try {
                if (BasicSearchNavigatorUI.this.helpsearch == null) {
                    BasicSearchNavigatorUI.this.helpsearch = BasicSearchNavigatorUI.this.searchnav.getSearchEngine();
                    BasicSearchNavigatorUI.this.searchquery = BasicSearchNavigatorUI.this.helpsearch.createQuery();
                    BasicSearchNavigatorUI.this.searchquery.addSearchListener(BasicSearchNavigatorUI.this);
                }
                BasicSearchNavigatorUI.debug("click on search w/: " + BasicSearchNavigatorUI.this.searchparams.getText());
                if (BasicSearchNavigatorUI.this.searchquery.isActive()) {
                    BasicSearchNavigatorUI.this.searchquery.stop();
                }
                BasicSearchNavigatorUI.this.searchquery.start(BasicSearchNavigatorUI.this.searchparams.getText(), BasicSearchNavigatorUI.this.searchnav.getLocale());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

