/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import javax.help.Map;
import javax.help.SearchTOCItem;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class BasicSearchCellRenderer
extends JPanel
implements TreeCellRenderer {
    protected boolean selected;
    private boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    protected Map map;
    protected JLabel treeIcon;
    protected JLabel hits;
    protected JLabel quality;
    protected JLabel title;
    private ImageIcon high = this.getIcon("images/high.gif");
    private ImageIcon medhigh = this.getIcon("images/medhigh.gif");
    private ImageIcon med = this.getIcon("images/med.gif");
    private ImageIcon medlow = this.getIcon("images/medlow.gif");
    private ImageIcon low = this.getIcon("images/low.gif");
    private static boolean debug = false;
    static /* synthetic */ Class class$javax$help$plaf$basic$BasicSearchNavigatorUI;

    public BasicSearchCellRenderer(Map map) {
        this.map = map;
        this.setLeafIcon(UIManager.getIcon("Tree.leafIcon"));
        this.setClosedIcon(UIManager.getIcon("Tree.closedIcon"));
        this.setOpenIcon(UIManager.getIcon("Tree.openIcon"));
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        Object object = UIManager.get("Tree.drawsFocusBorderAroundIcon");
        this.drawsFocusBorderAroundIcon = object != null && (Boolean)object != false;
        this.setLayout(new BoxLayout(this, 0));
        this.treeIcon = new JLabel();
        this.hits = new JLabel();
        this.hits.setHorizontalAlignment(2);
        this.quality = new JLabel();
        this.title = new JLabel();
        this.title.setHorizontalAlignment(2);
        this.add(this.treeIcon);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.hits);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.quality);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(this.title);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println("BasicSearchCellRenderer: " + string);
        }
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDefaultClosedIcon() {
        return this.closedIcon;
    }

    public Icon getDefaultLeafIcon() {
        return this.leafIcon;
    }

    public Icon getDefaultOpenIcon() {
        return this.openIcon;
    }

    public static ImageIcon getIcon(Class clazz, String string) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = new ImageIcon(clazz.getResource(string));
        }
        catch (Exception exception) {}
        if (debug || imageIcon == null) {
            System.err.println("GetIcon");
            System.err.println("  name: " + string);
            System.err.println("  klass: " + clazz);
            URL uRL = clazz.getResource(string);
            System.err.println("  URL is " + uRL);
            System.err.println("  ImageIcon is " + imageIcon);
        }
        return imageIcon;
    }

    private ImageIcon getIcon(String string) {
        return BasicSearchCellRenderer.getIcon(class$javax$help$plaf$basic$BasicSearchNavigatorUI != null ? class$javax$help$plaf$basic$BasicSearchNavigatorUI : (class$javax$help$plaf$basic$BasicSearchNavigatorUI = BasicSearchCellRenderer.class$("javax.help.plaf.basic.BasicSearchNavigatorUI")), string);
    }

    private int getLabelStart() {
        Icon icon = this.treeIcon.getIcon();
        if (icon != null && this.title.getText() != null) {
            return this.title.getX() - 1;
        }
        return 0;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2;
        Serializable serializable;
        SearchTOCItem searchTOCItem = (SearchTOCItem)((DefaultMutableTreeNode)object).getUserObject();
        String string = "";
        if (searchTOCItem != null) {
            string = searchTOCItem.getName();
        }
        if (bl) {
            this.treeIcon.setBackground(this.getBackground());
            this.hits.setForeground(this.getTextSelectionColor());
            this.title.setForeground(this.getTextSelectionColor());
            this.title.setBackground(this.getBackgroundSelectionColor());
        } else {
            serializable = this.getBackgroundNonSelectionColor();
            if (serializable == null) {
                serializable = this.getBackground();
            }
            this.treeIcon.setBackground(this.getBackground());
            this.hits.setForeground(this.getTextNonSelectionColor());
            this.title.setForeground(this.getTextNonSelectionColor());
            this.title.setBackground((Color)serializable);
        }
        serializable = null;
        if (searchTOCItem != null && (object2 = searchTOCItem.getImageID()) != null) {
            try {
                URL uRL = this.map.getURLFromID((Map.ID)object2);
                serializable = new ImageIcon(uRL);
            }
            catch (Exception exception) {}
        }
        if (searchTOCItem != null && (object2 = searchTOCItem.getLocale()) != null) {
            this.setLocale((Locale)object2);
        }
        if (serializable != null) {
            this.treeIcon.setIcon((Icon)((Object)serializable));
        } else if (bl3) {
            this.treeIcon.setIcon(this.getLeafIcon());
        } else if (bl2) {
            this.treeIcon.setIcon(this.getOpenIcon());
        } else {
            this.treeIcon.setIcon(this.getClosedIcon());
        }
        if (searchTOCItem != null) {
            this.hits.setText(String.valueOf(searchTOCItem.hitCount()));
            double d = searchTOCItem.getConfidence();
            if (d < 1.0) {
                this.quality.setIcon(this.high);
            } else if (d < 5.0) {
                this.quality.setIcon(this.medhigh);
            } else if (d < 12.5) {
                this.quality.setIcon(this.med);
            } else if (d < 25.0) {
                this.quality.setIcon(this.medlow);
            } else {
                this.quality.setIcon(this.low);
            }
            this.title.setText(string);
        }
        this.selected = bl;
        this.hasFocus = bl4;
        return this;
    }

    public void paint(Graphics graphics) {
        Color color;
        if (this.selected) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        int n = -1;
        if (color != null) {
            n = this.getLabelStart();
            graphics.setColor(color);
            graphics.fillRect(n, 0, this.getWidth() - 1 - n, this.getHeight());
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                n = 0;
            } else if (n == -1) {
                n = this.getLabelStart();
            }
            graphics.setColor(this.getBorderSelectionColor());
            graphics.drawRect(n, 0, this.getWidth() - 1 - n, this.getHeight() - 1);
        }
        super.paintChildren(graphics);
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }
}

