% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_imp_distr.R
\name{plot_imp_distr}
\alias{plot_imp_distr}
\title{Plot the distribution of observed and imputed values}
\usage{
plot_imp_distr(data, imp = "Imputation_", id = ".id", rownr = ".rownr",
  ncol = NULL, nrow = NULL, labeller = NULL)
}
\arguments{
\item{data}{a \code{data.frame} containing multiple imputations
and the original incomplete data stacked onto each other}

\item{imp}{the name of the variable specifying the imputation indicator}

\item{id}{the name of the variable specifying the subject indicator}

\item{rownr}{the name of a variable identifying which rows correspond to the
same observation in the original (un-imputed) data}

\item{ncol}{optional; number of columns in the plot layout;
automatically chosen if unspecified}

\item{nrow}{optional; number of rows in the plot layout;
automatically chosen if unspecified}

\item{labeller}{optional labeller to be passed to
\code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}}
to change the facet labels}
}
\description{
Plots densities and bar plots of the observed and imputed values in a
long-format dataset (multiple imputed datasets stacked onto each other).
}
\examples{
mod <- lme_imp(y ~ C1 + c2 + B2 + C2, random = ~ 1 | id, data = longDF,
               n.iter = 200, monitor_params = c(imps = TRUE), mess = FALSE)
impDF <- get_MIdat(mod, m = 5)
plot_imp_distr(impDF, id = "id", ncol = 3)

}
