% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformSSM.R
\name{transformSSM}
\alias{transformSSM}
\title{Transform Multivariate State Space Model for Sequential Processing}
\usage{
transformSSM(object, type = c("ldl", "augment"))
}
\arguments{
\item{object}{State space model object from function \code{\link{SSModel}}.}

\item{type}{Option \code{"ldl"} performs LDL decomposition for covariance matrix \eqn{H_t}{H[t]},
and multiplies the observation equation with the \eqn{L_t^{-1}}{L[t]^-1}, so \eqn{\epsilon_t^* 
\sim N(0,D_t)}{\epsilon[t]* ~ N(0,D[t])}. Option \code{"augment"} adds 
\eqn{\epsilon_t}{\epsilon[t]} to the state vector, so \eqn{Q_t}{Q[t]} becomes block diagonal 
with blocks \eqn{Q_t}{Q[t]} and \eqn{H_t}{H[t]}.}
}
\value{
\item{model}{Transformed model.}
}
\description{
\code{transformSSM} transforms the general multivariate Gaussian state space model
to form suitable for sequential processing.
}
\details{
As all the functions in KFAS use univariate approach i.e. sequential processing, 
  the covariance matrix \eqn{H_t}{H[t]} of the observation equation needs to be 
  either diagonal or zero matrix. Function \code{transformSSM} performs either 
  the LDL decomposition of \eqn{H_t}{H[t]}, or augments the state vector with
  the disturbances of the observation equation.
  
  In case of a LDL decomposition, the new \eqn{H_t}{H[t]} contains the diagonal part of the 
  decomposition, whereas observations \eqn{y_t}{y[t]} and system matrices \eqn{Z_t}{Z[t]} are 
  multiplied with the inverse of \eqn{L_t}{L[t]}. Note that although the state estimates and 
  their error covariances obtained by Kalman filtering and smoothing are identical with those 
  obtained from ordinary multivariate filtering, the one-step-ahead errors 
  \eqn{v_t}{v[t]} and their variances \eqn{F_t}{F[t]} do differ. The typical 
  multivariate versions can be obtained from output of \code{\link{KFS}}
  using \code{\link{mvInnovations}} function.
}

