\name{rcpp_tapply_generator}
\alias{Rcpp_tapply_generator}
\alias{rcpp_tapply_generator}
\title{Rcpp tapply Generator}
\usage{
rcpp_tapply_generator(fun, includes = NULL, depends = NULL, inline = TRUE,
  returnType = "double", name = NULL, file = NULL, additional = NULL)

Rcpp_tapply_generator(fun, includes = NULL, depends = NULL, inline = TRUE,
  returnType = "double", name = NULL, file = NULL, additional = NULL)
}
\arguments{
  \item{fun}{A character string defining the C++ function.
  It must be in terms of a variable \code{x}.}

  \item{includes}{Other C++ libraries to include. For
  example, to include \code{boost/math.hpp}, you could pass
  \code{c("<boost/math.hpp>")}. Rcpp is included by
  default, unless RcppArmadillo is included as well (since
  Rcpp is included as part of the RcppArmadillo include)}

  \item{depends}{Other libraries to link to. Linking is
  done through Rcpp attributes.}

  \item{returnType}{The return type of your function; note
  that we require that the generator returns a scalar value
  of type \code{double}, \code{int}, or \code{bool}.}

  \item{inline}{boolean; mark this function as inline? This
  may or may not increase execution speed.}

  \item{name}{An internal name for the function.}

  \item{file}{A location to output the file. Defaults to a
  temporary file as generated by \code{\link{tempfile}()}.}

  \item{additional}{Other C++ code you want to include;
  e.g. helper functions. This code will be inserted as-is
  above the code in \code{fun}.}
}
\description{
Use this function as a generator for your own \code{tapply}
functions; that is, functions you would like to apply split
over some grouping variable. Note that we restrict
ourselves to the case where we return a scalar as output;
rather than the more general output of \code{tapply}.
}
\details{
Note that we simplify differently than base \R
\code{tapply}: when \code{simplify=TRUE}, we call
\code{unlist} on the output; hence, a named vector is
returned.
}

