/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.utils.JarResources;
import org.apache.lucene.analysis.kr.utils.StringUtil;

public class FileUtil {
    public static File getClassLoaderFile(String filename) throws MorphException {
        File file = null;
        ClassLoader loader = FileUtil.class.getClassLoader();
        URL url = loader.getResource(filename);
        if (url == null) {
            url = ClassLoader.getSystemResource(filename);
            if (url == null) {
                throw new MorphException("Unable to find " + filename);
            }
            file = FileUtil.toFile(url);
        } else {
            file = FileUtil.toFile(url);
        }
        if (file == null || !file.exists()) {
            return null;
        }
        return file;
    }

    public static List readLines(File file, String encoding) throws IOException {
        FileInputStream in = null;
        try {
            in = FileUtil.openInputStream(file);
            List list = FileUtil.readLines(in, encoding);
            return list;
        }
        finally {
            FileUtil.closeQuietly(in);
        }
    }

    public static List readLines(String fName, String encoding) throws Exception {
        List list;
        InputStream in = null;
        try {
            File file = FileUtil.getClassLoaderFile(fName);
            in = file != null && file.exists() ? FileUtil.openInputStream(file) : new ByteArrayInputStream(FileUtil.readByteFromCurrentJar(fName));
            list = FileUtil.readLines(in, encoding);
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly(in);
            throw throwable;
        }
        FileUtil.closeQuietly(in);
        return list;
    }

    public static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
        } else {
            throw new FileNotFoundException("File '" + file + "' does not exist");
        }
        return new FileInputStream(file);
    }

    public static List readLines(InputStream input) throws IOException {
        InputStreamReader reader = new InputStreamReader(input);
        return FileUtil.readLines(reader);
    }

    public static List readLines(InputStream input, String encoding) throws IOException {
        if (encoding == null) {
            return FileUtil.readLines(input);
        }
        InputStreamReader reader = new InputStreamReader(input, encoding);
        return FileUtil.readLines(reader);
    }

    public static List readLines(Reader input) throws IOException {
        BufferedReader reader = new BufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            list.add(line);
            line = reader.readLine();
        }
        return list;
    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static File toFile(URL url) {
        if (url == null || !url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        int pos = 0;
        while ((pos = filename.indexOf(37, pos)) >= 0) {
            if (pos + 2 >= filename.length()) continue;
            String hexStr = filename.substring(pos + 1, pos + 3);
            char ch = (char)Integer.parseInt(hexStr, 16);
            filename = String.valueOf(filename.substring(0, pos)) + ch + filename.substring(pos + 3);
        }
        return new File(filename);
    }

    public static String readFileToString(File file, String encoding) throws IOException {
        FileInputStream in = null;
        try {
            in = FileUtil.openInputStream(file);
            String string = StringUtil.toString(in, encoding);
            return string;
        }
        finally {
            FileUtil.closeQuietly(in);
        }
    }

    public static byte[] readByteFromCurrentJar(String resource) throws MorphException {
        String jarPath = FileUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        JarResources jar = new JarResources(jarPath);
        try {
            return jar.getResource(resource);
        }
        catch (Exception e) {
            throw new MorphException(e.getMessage(), e);
        }
    }
}

