% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LAGOSNE-package.R
\docType{data}
\name{locus}
\alias{locus}
\alias{location}
\title{Metadata for all lakes > 1ha}
\format{A data frame with 141265 observations of 17 variables:
\itemize{
            \item lagoslakeid: unique identifier for each lake in LAGOS-NE.
            For each row of data in this table, the lagoslakeid identifies the focal lake
            for which other measures are calculated
            \item nhdid: the 'Permanent_identifier' from the NHD,
            but is called the NHDID in LAGOS-NE
            \item gnis_name: lake name from the GNIS database
            \item nhd_lat: latitude of centroid of the NHD lake polygon in decimal
            degrees (NAD83)
            \item nhd_long: longitude of centroid of the NHD lake polygon in decimal
            degrees (NAD83)
            \item lake_area_ha: surface area (in hectares) of lake waterbody polygon from NHD
            \item lake_perim_meters: perimeter (in meters) of lake waterbody polygon from the NHD
            \item nhd_fcode: NHD five-digit integer code with feature code plus additional
            characteristics/values
            \item nhd_ftype: NHD three-digit integer code providing a unique identifier of feature
            type for the waterbody
            \item iws_zoneid: the  unique ID of the IWS that is estimated for the focal lake
            in the row of data that is identified by the lagoslakeid.
            \item hu4_zoneid: the unique ID of the HU4 zone that the focal lake is located within
            \item hu6_zoneid: the unique ID of the HU6 zone that the focal lake is located within
            \item hu8_zoneid: the unique ID of the HU8 zone that the focal lake is located within
            \item hu12_zoneid: the unique ID of the HU12 zone that the focal lake is located within
            \item edu_zoneid: the unique ID of the EDU zone that the focal lake is located within
            \item county_zoneid: the unique ID of the county that the focal lake is located within
            \item state_zoneid: the unique ID of the state that the focal lake is located within
            \item elevation_m: the elevation of the lake centroid, in meters (referenced to the
            North American Vertical Datum of 1988 (NAVD88)) and obtained from the National Elevation Dataset
    }}
\description{
A dataset containing identifying information for all lakes > 1ha. This includes
lake name, lake size (area and perimeter), location (lat/long), elevation,
and codes identifying zones in which the lake is located.
}
\references{
Soranno et al. (2017) \href{https://doi.org/10.1093/gigascience/gix101}{Gigascience 6:12}
}
\keyword{datasets}
