% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{LCox}
\alias{LCox}
\title{Hypothesis Testing for longitudinal gene profiles and the survival outcome.}
\usage{
LCox(data = NULL, data.id = NULL, geneID = 3:4, varID = NULL,
  PLOT = FALSE, optns = list(dataType = "Sparse", FVEthreshold = 0.95,
  methodBwMu = "CV"))
}
\arguments{
\item{data}{A data frame contains longitudinal gene expression data. This data
frame must contain a column of \code{ID} to identify each patient and a column of
\code{years} to indicate the follow-up time for each data point.}

\item{data.id}{A data frame contains the survival outcome and important covariates.
This data frame must contain a column of \code{ID} to identify each patient,
a column of \code{fstat} to indicate the censoring time, and a column of \code{ftime}
to indicate the survival time.}

\item{geneID}{A vector of integers indicates the column numbers in \code{data}
for the genes of interest.}

\item{varID}{A vector of integers indicates the column numbers in \code{data.id}
for the important confounding covariates that need to be included.}

\item{PLOT}{A logical value indicates whether a graph showing the fitted lines is desired.
If TRUE, a figure "fitted.pdf" will be saved to the current working directory.}

\item{optns}{A list of options control parameters for the FPCA model.}
}
\value{
returns a matrix with one column being the p values and the other
column being the number of eigenfunctions (K).
}
\description{
\code{LCox} is a function that performs hypothesis tests of the associations
between longitudinal gene profiles and the survival outcome.
}
\examples{
data.list = simudata()
data = data.list$data
data.id = data.list$data.id
res = LCox(data = data, data.id = data.id, geneID = 3:4)
res = LCox(data = data, data.id = data.id, geneID = 3:4, varID = 4)
res = LCox(data = data, data.id = data.id, geneID = 3:4, PLOT=TRUE)
}
\references{
LCox: A tool for selecting genes related to survival outcomes
using longitudinal gene expression data. Jiehuan Sun, Jose D. Herazo-Maya,
Jane-Ling Wang, Naftali Kaminski, and Hongyu Zhao.
}
