% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA.R
\name{select_LDA}
\alias{select_LDA}
\title{Select the best LDA model(s) for use in time series}
\usage{
select_LDA(LDA_models = NULL, control = list())
}
\arguments{
\item{LDA_models}{An object of class \code{LDA_set} produced by
\code{\link{LDA_set}}.}

\item{control}{A \code{list} of parameters to control the running and 
selecting of LDA models. Values not input assume default values set 
by \code{\link{LDA_set_control}}. Values for running the LDAs replace 
defaults in (\code{LDAcontol}, see \code{\link[topicmodels]{LDA}} (but if
 \code{seed} is given, it will be overwritten; use \code{iseed} instead).}
}
\value{
A reduced version of \code{LDA_models} that only includes the 
  selected LDA model(s). The returned object is still an object of
  class \code{LDA_set}.
}
\description{
Select the best model(s) of interest from an
  \code{LDA_set} object, based on a set of user-provided functions. The
  functions default to choosing the model with the lowest AIC value.
}
\examples{
  data(rodents)
  lda_data <- rodents$document_term_table
  r_LDA <- LDA_set(lda_data, topics = 2, nseeds = 2)  
  select_LDA(r_LDA)                       

}
