% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDA_survival.R
\name{LDA_survival}
\alias{LDA_survival}
\title{LDA_survival}
\usage{
LDA_survival(x, name = "cell line a")
}
\arguments{
\item{x}{numeric data.frame or matrix with three columns (cells,
wells, positive wells, group)}

\item{name}{optional: experiment name (e.g. name of cell line)}
}
\value{
list object with LDA-activities as returned by LDA_activity_single
}
\description{
calculation of clonogenic survival in a table of data from a
  limiting dilution assay (LDA) experiment (i.e. cells, wells, positive
  wells, group).
}
\examples{
x <- data.frame("cells" = c(10,50,100,250,10,50,100,250),
                "wells" = rep(25,8),
                "positive" = c(2,5,10,20,1,2,6,11),
                "group" = c(rep("A",4),rep("B",4)))
act <- LDA_survival(x)
}
