% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIP.R
\name{AIPcalc}
\alias{AIPcalc}
\title{Calculation of Atherogenic Index of Plasma (AIP)}
\usage{
AIPcalc(TG, HDL, SI ,roundDigit)
}
\arguments{
\item{TG}{A vector or data frame column containing the triglyceride (TG) values to be used for the
calculation of the atherogenic index of plasma (AIP). TG and HDL must be of the same length.}

\item{HDL}{A vector or data frame column containing the high density lipoprotein (HDL) values
to be used for the calculation of the atherogenic index of plasma (AIP). TG and HDL
must be of the same length.}

\item{SI}{Boolean (default=TRUE). AIP is by definition calculated using SI units for TG and HDL
(mmol/L). If mg/dl units are provided instead, SI must be set to FALSE.}

\item{roundDigit}{Decimal digits to round the result to (default = 4).}
}
\value{
A vector of AIP values of length equal to the length of TG and HDL.
}
\description{
Calculates the Atherogenic Index of Plasma (AIP) from triglyceride and HDL values.
}
\examples{
\dontrun{
AIP = AIPcalc(sampleA$TG, sampleA$HDL)
}
}
\references{
Dobiasova M, Frohlich J. The plasma parameter log (TG/HDL-C)
as an atherogenic index: correlation with lipoprotein particle size and
esterification rate in apo B- lipoprotein-depleted plasma (FERHDL).
Clin Biochem. 2001, 34:583-88.

Tan MH, Johns D, Glazer NB. Pioglitazone reduces atherogenic index of plasma
in patients with type 2 diabetes. Clin Chem. 2004, 50:1184-88.

Nwagha UI, Ingweh JC. A significant indicator for the onset of
atherosclerosis during menopause in hypertensive females of South East Nigeria.
J Coll Med. 2005, 10(2):67-71.

Daniels LB, Laughlin G, Sarno MJ. Lp- PLA2 is an independent predictor of
incidence of coronary heart disease in apparently healthy older population.
J Am Col Cardiol. 2008,51:913-19.

Xiaowei Z, Lugang Y, Hui Z, Qinhua M, Xiaohua Z, Ting L, et al.
Atherogenic index of plasma is a novel and better biomarker associated with
obesity: A population- based cross-sectional study in China.
Lipids Health Dis. 2018,17(1):37.
}
