% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcfR2SnpMatrix.R
\name{vcfR2SnpMatrix}
\alias{vcfR2SnpMatrix}
\title{Extract genotype information from a vcfR object}
\usage{
vcfR2SnpMatrix(obj, phased = NULL, subjects = NULL)
}
\arguments{
\item{obj}{An instance or path of the \code{\link[vcfR]{vcfR-class}} object to be processed.}

\item{phased}{If \code{TRUE} the output genotype data are in the form of a \code{\link[snpStats]{XSnpMatrix-class}} object. Otherwise, they are in the form of a \code{\link[snpStats]{SnpMatrix-class}} object. 
If it is unspecified, the phasing status will be determined by checking the first entry in the gt slot of the vcfR object. If the first entry is also missing, the value will be set to \code{FALSE}.}

\item{subjects}{A character or factor containing subject IDs. If supplied, genotype info of only those subjects will be returned. 
This should be a subset of the sample IDs in the vcfR object.}
}
\value{
A list which contains the following components:
\item{genetic.distances}{ A numeric vector of the reference positions of SNPs. }
\item{subjectID}{ A character vector of IDs of the subjects which the returned genotype data belong to. }
\item{data}{An object of \code{\link[snpStats]{SnpMatrix-class}}/\code{\link[snpStats]{XSnpMatrix-class}} containing genotype data. }
}
\description{
Convert a \code{\link[vcfR]{vcfR-class}} object into a list composed of genetic distances, subject IDs, and a \code{\link[snpStats]{SnpMatrix-class}}/\code{\link[snpStats]{XSnpMatrix-class}} object.
}
\details{
In order to let \code{ vcfR2SnpMatrix} function properly, the input \code{\link[vcfR]{vcfR-class}} object is expected to be generated from a valid VCF file which contains only biallelic SNPs and includes a GT section.
}
\examples{
# Load the vcfR object
require(vcfR)
data(vcfR_example)
vcf <- vcf[8:12,]

# Extract needed genotype information
alist <- vcfR2SnpMatrix(vcf)

# Draw a pairwise LD plot using the extracted data
LDheatmap(alist$data, alist$genetic.distance)


}
\seealso{
\code{\link[vcfR]{read.vcfR}}, \code{\link[snpStats]{SnpMatrix-class}}, \code{\link[snpStats]{XSnpMatrix-class}}
}
\keyword{hplot}
