% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLHD.R
\name{SLHD}
\alias{SLHD}
\title{Sliced Latin Hypercube Design (SLHD)}
\usage{
SLHD(
  n,
  k,
  t = 1,
  N = 10,
  T0 = 10,
  rate = 0.1,
  Tmin = 1,
  Imax = 3,
  OC = "phi_p",
  p = 15,
  q = 1,
  stage2 = FALSE
)
}
\arguments{
\item{n}{A positive integer.}

\item{k}{A positive integer.}

\item{t}{A positive integer.}

\item{N}{A positive integer.}

\item{T0}{A positive number.}

\item{rate}{A positive percentage.}

\item{Tmin}{A positive number.}

\item{Imax}{A positive integer.}

\item{OC}{An optimality criterion.}

\item{p}{A positive integer.}

\item{q}{The default is set to be 1, and it could be either 1 or 2.}

\item{stage2}{The default is set to be FALSE, and it could be either FALSE or TRUE.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} LHD.
}
\description{
\code{SLHD} returns an LHD matrix generated by "improved two-stage algorithm" from Ba et al. (2015).
}
\details{
\itemize{
\item \code{n} stands for the number of rows (or run size).
\item \code{k} stands for the number of columns (or the number of factors).
\item \code{t} stands for the number of slices. \code{n}/\code{t} must be an integer, that is, n is divisible by t. \code{t} must not exceed \code{k} when \code{n} is 9 or larger, and \code{t} must be smaller than \code{k} when \code{n} is smaller than 9. Otherwise, the funtion will never stop. The default is set to be 1.
\item \code{N} stands for the number of iterations. The default is set to be 10.
\item \code{T0} stands for the user-defined initial temperature. The default is set to be 10.
\item \code{rate} stands for temperature decrease rate, and it should be in (0,1). For example, rate=0.25 means the temperature decreases by 25\% each time. The default is set to be 10\%.
\item \code{Tmin} stands for the minimium temperature allowed. When current temperature becomes smaller or equal to \code{Tmin}, the stopping criterion for current loop is met. The default is set to be 1.
\item \code{Imax} stands for the maximum perturbations the algorithm will try without improvements before temperature is reduced. For the computation complexity consideration, \code{Imax} is recommended to be smaller or equal to 3, which is the default setting.
\item \code{OC} stands for the optimality criterion, the default setting is "phi_p", and it could be one of the following: "phi_p", "AvgAbsCor", "MaxAbsCor", "MaxProCriterion".
\item \code{p} is the parameter in the phi_p formula, and \code{p} is prefered to be large. The default is set to be 15.
\item If \code{q} is 1 (the default setting), \code{dij} is the rectangular distance. If \code{q} is 2, \code{dij} is the Euclidean distance.
\item If \code{stage2} is FALSE (the default setting), \code{SLHD} will only implement the first stage of the algorithm. If \code{stage2} is TRUE, \code{SLHD} will implement the whole algorithm.
}
}
\note{
As mentioned from the original paper, the first stage plays a much more important role since it optimizes the slice level. More resources should be given to the first stage if computational budgets are limited. Let m=n/t, where m is the number of rows for each slice, if (m)^k >> n, the second stage becomes optional. That is the reason why we add a \code{stage2} parameter to let users decide if the second stage is needed.
}
\examples{
#generate a 5 by 3 maximin distance LHD with the default setting
trySLHD1=SLHD(n=5,k=3)
trySLHD1
phi_p(trySLHD1)   #calculate the phi_p of "trySLHD1".

#generate a 5 by 3 maximin distance LHD with stage II
#let stage2=TRUE and other input are the same as above
trySLHD2=SLHD(n=5,k=3,stage2=TRUE)
trySLHD2
phi_p(trySLHD2)   #calculate the phi_p of "trySLHD2".

#Another example
#generate a 8 by 4 nearly orthogonal LHD
trySLHD3=SLHD(n=8,k=4,OC="AvgAbsCor",stage2=TRUE)
trySLHD3
AvgAbsCor(trySLHD3)  #calculate the average absolute correlation.
}
\references{
Ba, S., Myers, W.R., and Brenneman, W.A. (2015) Optimal Sliced Latin Hypercube Designs. \emph{Technometrics}, \strong{57}, 479-487.
}
