% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R, R/plot.R
\name{autoplot.residuals_lmm}
\alias{autoplot.residuals_lmm}
\alias{plot.residuals_lmm}
\title{Graphical Display of the Residuals}
\usage{
\method{autoplot}{residuals_lmm}(
  object,
  type = NULL,
  type.residual = NULL,
  by.repetition = TRUE,
  engine.qqplot = "ggplot2",
  add.smooth = TRUE,
  digits.cor = 2,
  size.text = 16,
  mean.size = c(3, 1),
  ci.alpha = 0.25,
  scales = "free",
  labeller = "label_value",
  ...
)

\method{plot}{residuals_lmm}(x, ...)
}
\arguments{
\item{object, x}{an object of class \code{residuals_lmm}, output of the \code{residuals.lmm} function.}

\item{type}{[character] Should a qqplot (\code{"qqplot"}), or a heatmap of the correlation between residuals  (\code{"correlation"}, require wide format), or a plot of residuals along the fitted values (\code{"scatterplot"}, require long format) be displayed?}

\item{type.residual}{[character] Type of residual for which the graphical representation should be made.}

\item{by.repetition}{[logical] Should a seperate graphical display be made for each repetition.}

\item{engine.qqplot}{[character] Should ggplot2 or qqtest be used to display quantile-quantile plots?
Only used when argument \code{type} is \code{"qqplot"}.}

\item{add.smooth}{[logical] should a local smoother be used to display the mean of the residual values across the fitted values.
Only relevant for when argument \code{type} is \code{"scatterplot"}.}

\item{digits.cor}{[integer, >0] Number of digit used to display the correlation coefficients?
No correlation coefficient is displayed when set to 0. Only used when argument \code{plot} is \code{"correlation"}.}

\item{size.text}{[numeric, >0] Size of the font used to displayed text when using ggplot2.}

\item{mean.size}{[numeric vector of length 2] size of the point and line for the mean trajectory.}

\item{ci.alpha}{[numeric, 0-1] When not NA, transparency parameter used to display the confidence intervals.}

\item{scales, labeller}{[character] Passed to \code{ggplot2::facet_wrap}.}

\item{...}{Not used. For compatibility with the generic method.}
}
\value{
A list with two elements \itemize{
\item \code{data}: data used to generate the plot.
\item \code{plot}: ggplot object.
}
}
\description{
Graphical representation of the residuals from a linear mixed model.
Require a long format (except for the correlation where both format are accepted) and having exported the dataset along with the residual (argument \code{keep.data} when calling \code{residuals.lmm}).
}
\section{Functions}{
\itemize{
\item \code{plot(residuals_lmm)}: Graphical Display of the Residuals

}}
\keyword{hplot}
