% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpe3.R
\name{qpe3}
\alias{qpe3}
\title{Quantile distribution function of Pearson type-3 Distribution}
\usage{
qpe3(u = NULL, RP = 1/(1 - u), para)
}
\arguments{
\item{u}{non-exceedance probability}

\item{RP}{Return Period "don't use in case u is used"}

\item{para}{parameters as c(mu, sigma, gamma) that is c(location, scale, shape).}
}
\value{
Quantile value/s using the inverse of the cumulative distribution function.
}
\description{
Quantile distribution function of Pearson type-3 Distribution
}
\examples{

x <- qpe3(u = 0.99, para = c(1, 1, 0))
x <- qpe3(RP = 100, para = c(1, 1, 0))

}
\author{
Mohanad Zaghloul [aut, cre], Simon Michael Papalexiou [aut, ths], Amin Elshorbagy [aut, ths]
}
