% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{score}
\alias{score}
\title{Score of Lags}
\usage{
score(corr, lags)
}
\arguments{
\item{corr}{a vector of computed correlation}

\item{lags}{a vector of same length with corr that holds the lags corresponding to the corr vector}
}
\value{
a numerical value of best lag picked based on corr and lags
}
\description{
This function computes the score of best lags by summing the correlation of corresponding lags
}
\examples{
score(runif(10, 0, 1), c(2, 0, 0, 0, 3, 2, -1, 2, 0, 1))
score(runif(20, 0.5, 0.8), sample(-3:3, size = 20, replace = TRUE))


}
\author{
Thevaa Chandereng, Anthony Gitter
}
