% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cauchy_tests.R
\name{cauchy_location_lr_test}
\alias{cauchy_location_lr_test}
\title{Test the location parameter of a cauchy distribution using the likelihood ratio test.}
\source{
\url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
}
\usage{
cauchy_location_lr_test(
  x,
  location,
  alternative = "two.sided",
  conf.level = 0.95
)
}
\arguments{
\item{x}{a numeric vector of at least 50 data values.}

\item{location}{a number indicating the tested value of the location parameter.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of "two.sided" (default), "greater" or "less".}

\item{conf.level}{confidence level of the likelihood interval.}
}
\value{
An S3 class containing the test statistic, p value, likelihood based confidence interval, and alternative
hypothesis.
}
\description{
Test the location parameter of a cauchy distribution using the likelihood ratio test.
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rcauchy(n = 100, location = 1, scale = 2)
cauchy_location_lr_test(x, 1, "two.sided")

# Null is false
set.seed(1)
x <- rcauchy(n = 100, location = 3, scale = 2)
cauchy_location_lr_test(x, 1, "greater")
}
