% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kendler_functions.R
\name{kendler}
\alias{kendler}
\title{Title Kendler's FGRS}
\usage{
kendler(
  .tbl = NULL,
  family_graphs = NULL,
  family_graphs_col = "fam_graph",
  pid = "pid",
  fid = "fid",
  role = NULL,
  dadcol,
  momcol,
  env_cor_sib = 1,
  env_cor_f = 1,
  env_cor_m = 1
)
}
\arguments{
\item{.tbl}{A matrix, list or data frame that can be converted into a tibble.
Must have at least five columns that hold the family identifier, the personal
identifier, the role and the lower and upper thresholds. Note that the
role must be one of the following abbreviations
- \code{g} (Genetic component of full liability)
- \code{o} (Full liability)
- \code{m} (Mother)
- \code{f} (Father)
- \code{c[0-9]*.[0-9]*} (Children)
- \code{mgm} (Maternal grandmother)
- \code{mgf} (Maternal grandfather)
- \code{pgm} (Paternal grandmother)
- \code{pgf} (Paternal grandfather)
- \code{s[0-9]*} (Full siblings)
- \code{mhs[0-9]*} (Half-siblings - maternal side)
- \code{phs[0-9]*} (Half-siblings - paternal side)
- \code{mau[0-9]*} (Aunts/Uncles - maternal side)
- \code{pau[0-9]*} (Aunts/Uncles - paternal side).
Defaults to \code{NULL}.}

\item{family_graphs}{A tibble with columns pid and family_graph_col.
See prepare_graph for construction of the graphs. The family graphs Defaults to NULL.}

\item{family_graphs_col}{Name of column with family graphs in family_graphs. Defaults to "fam_graph".}

\item{pid}{A string holding the name of the column in \code{.tbl} (or \code{family} and
\code{threshs}) that hold the personal identifier(s). Defaults to "PID".}

\item{fid}{A string holding the name of the column in \code{.tbl} or \code{family} that
holds the family identifier. Defaults to "fid".}

\item{role}{A string holding the name of the column in \code{.tbl} that
holds the role. Each role must be chosen from the following list of abbreviations
- \code{g} (Genetic component of full liability)
- \code{o} (Full liability)
- \code{m} (Mother)
- \code{f} (Father)
- \code{c[0-9]*.[0-9]*} (Children)
- \code{mgm} (Maternal grandmother)
- \code{mgf} (Maternal grandfather)
- \code{pgm} (Paternal grandmother)
- \code{pgf} (Paternal grandfather)
- \code{s[0-9]*} (Full siblings)
- \code{mhs[0-9]*} (Half-siblings - maternal side)
- \code{phs[0-9]*} (Half-siblings - paternal side)
- \code{mau[0-9]*} (Aunts/Uncles - maternal side)
- \code{pau[0-9]*} (Aunts/Uncles - paternal side).
Defaults to "role".}

\item{dadcol}{column name of father in family_graphs or .tbl.}

\item{momcol}{column name of mother in family_graphs or .tbl.}

\item{env_cor_sib}{Cohabitation effect, i.e. Factor by which the siblings are weighted. Defaults to 1.}

\item{env_cor_f}{Cohabitation effect, i.e. Factor by which the father is weighted. Defaults to 1.}

\item{env_cor_m}{Cohabitation effect, i.e. Factor by which the mother is weighted. Defaults to 1.}
}
\value{
A tibble with summary values used to calculate the kendler FGRS and the FGRS itself.
}
\description{
Title Kendler's FGRS
}
\examples{
# See Vignettes.
}
