% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kendler_functions.R
\name{kendler_family_calculations}
\alias{kendler_family_calculations}
\title{Title Helper function for Kendler's FGRS}
\usage{
kendler_family_calculations(
  tbl,
  cov,
  pid,
  cur_dad_id,
  cur_mom_id,
  env_cor_sib = 1,
  env_cor_f = 1,
  env_cor_m = 1
)
}
\arguments{
\item{tbl}{tibble with columns cip, lower, upper, and pid (the personal identifier column).}

\item{cov}{Kinship matrix with proband as first row and column}

\item{pid}{column name of personal identifier}

\item{cur_dad_id}{ID of father (not column name, but the actual ID)}

\item{cur_mom_id}{ID of mother (not column name, but the actual ID)}

\item{env_cor_sib}{Cohabitation effect, i.e. Factor by which the siblings are weighted. Defaults to 1.}

\item{env_cor_f}{Cohabitation effect, i.e. Factor by which the father is weighted. Defaults to 1.}

\item{env_cor_m}{Cohabitation effect, i.e. Factor by which the mother is weighted. Defaults to 1.}
}
\value{
A tibble with family specific values required for Kendler's FGRS calculation.
}
\description{
Title Helper function for Kendler's FGRS
}
\examples{
# See Vignettes.
}
