% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LVGP_plot.R
\name{LVGP_plot}
\alias{LVGP_plot}
\title{The Plotting Function of \code{LVGP} Package}
\usage{
LVGP_plot(model, ind_qual_plot = NULL)
}
\arguments{
\item{model}{The LVGP model fitted by \code{\link[LVGP]{LVGP_fit}}}

\item{ind_qual_plot}{An array of index (indices) of the qualitative/categorical variable(s) to be plotted.
Default is NULL, in which case all the qualitative/categorical variables will be plotted.}
}
\description{
Plots the qualitative/categorical variable levels in the latent space (only for 1D or 2D cases).
    If the qualitative/categorical variables are not specified, all the qualified variables will be plotted.
    See \code{Arguments} for more details on the options.
}
\note{
This plot function \strong{only} works for 1D or 2D latent spaces.
}
\examples{
# see the examples in the documentation of the function LVGP_fit.
}
\references{
\enumerate{
\item "A Latent Variable Approach to Gaussian Process Modeling with Qualitative and Quantitative Factors", Yichi Zhang, Siyu Tao, Wei Chen, and Daniel W. Apley (\href{https://arxiv.org/abs/1806.07504}{arXiv})
}
}
\seealso{
\code{\link[LVGP]{LVGP_fit}} to fit LVGP model to the datasets.\cr
\code{\link[LVGP]{LVGP_predict}} to use the fitted LVGP model for prediction.
}
