% Generated by roxygen2 (4.0.2): do not edit by hand
\name{LambertW_fit-methods}
\alias{LambertW_fit-methods}
\alias{plot.LambertW_fit}
\alias{print.LambertW_fit}
\alias{print.summary.LambertW_fit}
\alias{summary.LambertW_fit}
\title{Methods for Lambert W\eqn{\times} F estimates}
\usage{
\method{plot}{LambertW_fit}(x, xlim = NULL, show.qqplot = FALSE, ...)

\method{print}{LambertW_fit}(x, ...)

\method{print}{summary.LambertW_fit}(x, ...)

\method{summary}{LambertW_fit}(object, ...)
}
\arguments{
\item{x,object}{object of class \code{LambertW_fit}}

\item{xlim}{lower and upper limit of x-axis for cdf and pdf plots.}

\item{show.qqplot}{should a Lambert W\eqn{ \times} F QQ plot be displayed? Default: \code{FALSE}.}

\item{\dots}{further arguments passed to or from other methods.}
}
\value{
\code{summary} returns a list of class \code{summary.LambertW_fit}
containing
\item{call}{function call}
\item{coefmat}{matrix with 4 columns: \eqn{\widehat{\theta}}, its standard errors, t-statistic, and
two-sided p-values}
\item{distname}{see Arguments}
\item{n}{number of observations}
\item{data}{original data (\code{y})}
\item{input}{back-transformed input data}
\item{support}{support of output random variable Y}
\item{data.range}{empirical data range}
\item{method}{estimation method}
\item{hessian}{Hessian at the optimum. Numerically obtained for \code{method = "MLE"};
for \code{method = "IGMM"} a diagonal-matrix approximation from covariance matrix
obtained by simulations for \eqn{n = 1000} observations.}
\item{p_m1, p_m1n}{Probability that one (or n) observation were caused by input
from the non-principal branch (see \code{\link{p_m1}}); only for \code{type = "s"}.}
\item{symmetry.p.value}{p-value from Wald test of identical left and right tail parameters (see
\code{\link{test_symmetry}}); only for \code{type = "hh"}.}
}
\description{
S3 methods (\code{print}, \code{plot}, \code{summary}, etc.) for the
class \code{LambertW_fit} of the \code{\link{MLE_LambertW}} or \code{\link{IGMM}} estimator.
See Details and Examples.

\code{plot.LambertW_fit} plots a (1) histogram, (2) empirical density of the
data \code{y}. These are compared (3) to the theoretical \eqn{F_X(x \mid
\widehat{\boldsymbol \beta})} and (4) Lambert W \eqn{\times}
\eqn{F_X(y \mid \widehat{\boldsymbol \beta})} densities.

\code{print.LambertW_fit} prints only very basic information about
\eqn{\widehat{\theta}} (to prevent an overload of data/information in the
console when executing an estimator).

\code{print.summary.LambertW_fit} tries to be smart about formatting the
coefficients, standard errors, etc. and also displays "significance stars"
(like in the output of \code{summary.lm}).

\code{summary.LambertW_fit} computes some auxiliary results from the estimate such as
standard errors, theoretical support (only for \code{type="s"}), skewness tests
(only for \code{type="hh"}), etc.  See \code{print.summary.LambertW_fit} for print out
in the console.
}
\examples{
# See ?LambertW-package
}
\keyword{hplot}
\keyword{print}

