% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/timeseries2D.r
\name{timeseries2D}
\alias{timeseries2D}
\title{Generate a 2D Langevin process}
\usage{
timeseries2D(N, startpointx = 0, startpointy = 0, D1_1 = matrix(c(0, -1,
  rep(0, 14)), nrow = 4), D1_2 = matrix(c(0, 0, 0, 0, -1, rep(0, 11)), nrow =
  4), g_11 = matrix(c(1, 0, 0, 0, 0, 0, 0, 0, 0), nrow = 3),
  g_12 = matrix(c(0, 0, 0, 0, 0, 0, 0, 0, 0), nrow = 3), g_21 = matrix(c(0,
  0, 0, 0, 0, 0, 0, 0, 0), nrow = 3), g_22 = matrix(c(1, 0, 0, 0, 0, 0, 0, 0,
  0), nrow = 3), sf = 1000, dt = 0)
}
\arguments{
\item{N}{a scalar denoting the length of the time-series to generate.}

\item{startpointx}{a scalar denoting the starting point of the time series x.}

\item{startpointy}{a scalar denoting the starting point of the time series y.}

\item{D1_1}{a 4x4 matrix denoting the coefficients of D1 for x.}

\item{D1_2}{a 4x4 matrix denoting the coefficients of D1 for y.}

\item{g_11}{a 3x3 matrix denoting the coefficients of g11 for x.}

\item{g_12}{a 3x3 matrix denoting the coefficients of g12 for x.}

\item{g_21}{a 3x3 matrix denoting the coefficients of g21 for y.}

\item{g_22}{a 3x3 matrix denoting the coefficients of g22 for y.}

\item{sf}{a scalar denoting the sampling frequency.}

\item{dt}{a scalar denoting the maximal time step of integration. Default
\code{dt=0} yields \code{dt=1/sf}.}
}
\value{
\code{timeseries2D} returns a time-series object with the generated
time-series as colums.
}
\description{
\code{timeseries2D} generates a two-dimensional Langevin process using a
simple Euler integration. The drift function is a cubic polynomial, the
diffusion function a quadratic.
}
\details{
The elements \eqn{a_{ij}} of the matrices are defined by the corresponding
equations for the drift and diffusion terms:

\deqn{D^1_{1,2} = \sum_{i,j=1}^4 a_{ij} x_1^{(i-1)}x_2^{(j-1)} }

with \eqn{a_{ij} = 0} for \eqn{ i + j > 5}.

\deqn{g_{11,12,21,22} = \sum_{i,j=1}^3 a_{ij} x_1^{(i-1)}x_2^{(j-1)} }

with \eqn{a_{ij} = 0} for \eqn{ i + j > 4}
}
\author{
Philip Rinn
}
\seealso{
\code{\link{timeseries1D}}
}

