% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potts.R
\name{potts}
\alias{potts}
\title{Linearized Bregman solver for composite conditionally likelihood of Potts model 
 with lasso penalty and block-group penalty.}
\usage{
potts(X, kappa, alpha, c = 1, tlist, nt = 100, trate = 100,
  type = c("entry", "block"), intercept = TRUE)
}
\arguments{
\item{X}{An n-by-p matrix of variables.}

\item{kappa}{The damping factor of the Linearized Bregman Algorithm that is
defined in the reference paper. See details.}

\item{alpha}{Parameter in Linearized Bregman algorithm which controls the 
step-length of the discretized solver for the Bregman Inverse Scale Space. 
See details.}

\item{c}{Normalized step-length. If alpha is missing, alpha is automatically generated by 
\code{alpha=c*n*p/(kappa*||XX^T*XX||_2)}, where XX is 0-1 indicator matrix 
induced by the class of each Xi. Default is 2. It should be in (0,2).
If beyond this range the path may be oscillated at large t values.}

\item{tlist}{Parameters t along the path.}

\item{nt}{Number of t. Used only if tlist is missing. Default is 100.}

\item{trate}{tmax/tmin. Used only if tlist is missing. Default is 100.}

\item{type}{Type of penalty, entry-wise l1 penalty or bolck-wise group penalty.}

\item{intercept}{if TRUE, an intercept is included in the model (and not 
penalized), otherwise no intercept is included. Default is TRUE.}
}
\value{
A "potts" class object is returned. The list contains the call, 
 the path, the intercept term a0 and value for alpha, kappa, t.
}
\description{
Solver for the entire solution path of coefficients.
}
\details{
The data matrix X is transformed into a 0-1 indicator matrix D with each column
\eqn{D_{jk}} means \eqn{1(X_j)==k}. The Potts model here used is described as following:
\deqn{P(x) \sim \exp(\sum_{jk} a_{0,jk}1(x_i=1) + d^T \Theta d/2)}
where \eqn{\Theta} is p-by-p symmetric and 0 on diagnal. Then conditional on \eqn{x_{-j}}\cr
\deqn{P(x_j=k) \sim exp(\sum_{k} a_{0,jk} + \sum_{i\neq j,r}\theta_{jk,ir}d_{ir})}\cr
then the composite conditional likelihood is like this:\cr
\deqn{- \frac{1}{p}\sum_{j} condloglik(X_j | X_{-j})}
}
\examples{
require(animation)
X = matrix(floor(runif(200*10)*3),200,10)
obj = potts(X,10,nt=100,trate=10,type= "block")
ncol = 50
breaks = seq(min(obj$path),max(obj$path),length.out=ncol+1)
saveGIF({
for (i in (1:20)*5) image(obj$path[,,i],col=rainbow(ncol),breaks=breaks)
}, movie.name = "Potts.gif", interval = 0.1, nmax = 20)

}
\author{
Jiechao Xiong
}
\keyword{regression}

