% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subfunctionsIdentification.R
\name{checkIntensityRules}
\alias{checkIntensityRules}
\title{Check intensity rules}
\usage{
checkIntensityRules(intrules, rates, intrequired, nchains, combinations)
}
\arguments{
\item{intrules}{character vector specifying the fragments to compare. See
details.}

\item{rates}{character vector with the expected rates between fragments given
as a string (i.e. "3/1"). See details.}

\item{intrequired}{logical vector indicating if any of the rules is required.
If not, at least one must be verified to confirm the structure.}

\item{nchains}{number of chains of the targeted lipid class.}

\item{combinations}{output of \link{combineChains}.}
}
\value{
List of logical vectors  with the confirmation for each combination.
}
\description{
Check intensity rules to confirm chains position.
}
\details{
This function will be employed when the targeted lipid class has
more than one chain.

Taking PG subclass as an example, intensities of lysoPG fragments
(informative for sn1) can be employed to confirm the chains structure
(intrules = c("lysopg_sn1/lysopg_sn1")). In this case, the intensity of the
lysoPG resulting from the loss of the FA chain in sn2 is at least 3 times
greater (rates = c("3/1")) than the lysoPG resulting from the loss of the FA
chain in sn1.

For the intrules argument, "/" will be use to separate the fragments related
to each chain (sn1/sn2/etc), and "_" will be use to indicate the list in
which they'll be searched. This will depend on the chain fragments
rules defined previously. Following the example, as we use lysoPG to define
the sn1 position, both fragments will be searched in this list (sn1).

For classes with more than one FA chain, if some intensity rule should be
employed to identify their position but they are no defined yet, use "Unknown".
If it is not necessary because the fragmentation rules are informative enough
to define the position (i.e. sphingolipid species), just leave an empty vector.
}
\examples{
\dontrun{
devtools::install_github("maialba3/LipidMSdata2")

library(LipidMS)
dbs <- assignDB()

MS1 <- LipidMSdata2::msobjectDIAneg$peaklist$MS1
MS1 <- MS1[MS1$isotope \%in\% c("[M+0]"), !colnames(MS1) \%in\% c("isotope", "group")]
MS2 <- LipidMSdata2::msobjectDIAneg$peaklist$MS2[,c("m.z", "RT", "int", "peakID")]
rawData <- rbind(LipidMSdata2::msobjectDIAneg$MS1, LipidMSdata2::msobjectDIAneg$MS2)

candidates <- findCandidates(MS1 = MS1, db = dbs$pgdb, ppm = 10,
rt = c(0, 2000), adducts = c("M-H"), rttol = 10, dbs = dbs,
rawData = rawData, coelCutoff = 0.8)
coelfrags <- coelutingFrags(candidates, MSMS, rttol = 10, rawData = rawData,
coelCutoff = 0.8)
classConf <- checkClass(candidates, coelfrags,
clfrags = c(227.0326, 209.022, 74.0359),
clrequisites = c(FALSE, FALSE, FALSE, FALSE),
ftype = c("F", "F", "NL"), ppm = 10, dbs = dbs)
sn1 <- chainFrags(coelfrags, chainfrags = c("lysopg_M-H"),
candidates = candidates, ppm = 10, dbs = dbs)
sn2 <- chainFrags(coelfrags, chainfrags = c("fa_M-H"), ppm = 10,
candidates = candidates, dbs = dbs)
chainsComb <- combineChains(candidates, nchains=2, sn1, sn2)

intConf <- checkIntensityRules(intrules = c("lysopg_sn1/lysopg_sn1"),
rates = c("2/1"), intrequired = c(TRUE), nchains=2, chainsComb)
}

}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
