% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subfunctionsIdentification.R
\name{checkClass}
\alias{checkClass}
\title{Search of class fragments to confirm the lipid class.}
\usage{
checkClass(candidates, coelfrags, clfrags, ftype, clrequisites, ppm = 10, dbs)
}
\arguments{
\item{candidates}{output of \link{findCandidates} function.}

\item{coelfrags}{list of peaks coeluting with each candidate. Output of
\link{coelutingFrags}.}

\item{clfrags}{vector containing the expected fragments for a given lipid
class. See details.}

\item{ftype}{character vector indicating the type of fragments in clfrags.
It can be: "F" (fragment), "NL" (neutral loss) or "BB" (building block).
See details.}

\item{clrequisites}{logical vector indicating if each class fragment is
required or not. If none of the fragment is required, at least one of them
must be present within the coeluting fragments. If the presence of any
fragment excludes the class, it can be specified by using "excluding".}

\item{ppm}{m/z tolerance in ppm.}

\item{dbs}{list of data bases required for the annotation. By default, dbs
contains the required data frames based on the default fragmentation rules.
If these rules are modified, dbs may need to be changed. If data bases have
been customized using \link{createLipidDB}, they also have to be modified
here. It is employed when some fragment belongs to "BB" \code{ftype}.}
}
\value{
List with 2 elements: a matrix with logical values (presence/absense)
of each expected fragment (columns) for each candidate (rows), and a logical
vector with the confirmation of the lipid class for each candidate.
}
\description{
Search of characteristic fragments that confirm a given lipid class.
}
\details{
\code{clfrags}, \code{ftype} and \code{clrequisites} will indicate
the rules to confirm a lipid class. All three arguments must have the same
length.

This function allows three different types of fragments: fragments with a
specific m/z as for example 227.0326 for PG in negative mode, which needs to
be defined as clfrags = c(227.0326) and ftype = c("F"); neutral losses such
as the head group of some PL (i.e. NL of 74.0359 in PG in negative mode),
which will be defined as clfrags = c(74.0359) and ftype = c("NL"); or
building blocks resulting from the loss of some groups, as for example, PA as
M-H resulting from the loss of the head group (glycerol) in PG in ESI-, which
will be defined as clfrags = c("pa_M-H") and ftype = c("BB"). The last
two options could define the same fragments. In this case just one of them
would be necessary.

When using the third type of fragment ("BB"), the building block will be
specified in lower case (i.e. pa, dg, lysopa, mg, etc.) and the adduct will be
given as it appears in the adductsTable, both separated by "_". Names for the
building blocks are the ones used for the LipidMS databases without the "db"
at the end.

In case the presence of a fragment indicates that the candidate does not
belong to the lipid class (i.e. loss of CH3 in PE, which corresponds to a PC
actually), this will be specified by using \code{clrequisites} = c("excluding").
}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
