% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify_SingleGrainData.R
\name{verify_SingleGrainData}
\alias{verify_SingleGrainData}
\title{Verify single grain data sets and check for invalid grains, i.e. zero light level grains}
\usage{
verify_SingleGrainData(object, threshold = 10, cleanup = FALSE,
  cleanup_level = "aliquot", verbose = TRUE)
}
\arguments{
\item{object}{\code{\linkS4class{Risoe.BINfileData}} or \code{\linkS4class{RLum.Analysis}}
(\bold{required}): input object. The function also accepts a list with objects of allowed type.}

\item{threshold}{\code{\link{numeric}} (with default): numeric threshold value for the allowed difference between
the \code{mean} and the \code{var} of the count values (see details)}

\item{cleanup}{\code{\link{logical}} (with default): if set to \code{TRUE} curves indentified as
zero light level curves are automatically removed. Ouput is an object as same type as the input, i.e.
either \code{\linkS4class{Risoe.BINfileData}} or \code{\linkS4class{RLum.Analysis}}}

\item{cleanup_level}{\code{\link{character}} (with default): selects the level for the cleanup
of the input data sets. Two options are allowed: \code{"curve"} or \code{"aliquot"}. If  \code{"curve"}
is selected every single curve marked as \code{invalid} is removed. If \code{"aliquot"} is selected,
curves of one aliquot (grain or disc) can be marked as invalid, but will not be removed. An aliquot
will be only removed if all curves of this aliquot are marked as invalid.}

\item{verbose}{\code{\link{logical}} (with default): enables or disables terminal feedback}
}
\value{
Returns either an S4 object of type \code{\linkS4class{RLum.Results}} and the slot
\code{data} contains a \code{\link{list}} with the following structure:\cr
$ unique_paris (\code{data.frame}): the unique position and grain pairs \cr
.. $ POSITION \cr
.. $ GRAIN \cr

$ selection_id (\code{numeric}): the made selection by record ID\cr

$ selection_full (\code{data.frame}): the full set with all criteria\cr
.. $ POSITION \cr
.. $ GRAIN \cr
.. $ MEAN \cr
.. $ VAR \cr
.. $ RATIO \cr
.. $ THRESHOLD \cr
.. $ VALID \cr

or for \code{cleanup = TRUE} the same object as the input, but with cleaned up (invalid curves removed).
This means: Either an \code{\linkS4class{Risoe.BINfileData}} or an \code{\linkS4class{RLum.Analysis}} object is returned.
An \code{\linkS4class{Risoe.BINfileData}} object can be exported to a BIN-file by using the function
\code{\link{write_R2BIN}}.
}
\description{
This function tries to identify automatically zero light level curves (grains) from single grain data
measurements. \cr
}
\details{
\bold{method}\cr

The function compares the mean and the variance of the count values for each curve. Assuming that
the background roughly follows a poission distribution the absolute difference of both values
should be zero or at least around zero. Values significantly above the threshold indicate that the curves
comprises a signal. The threshold can be freely chosen by the user.\cr

Note: the difference instead of the ratio was chosen as the mean and the variance can both become
0 which would result in \code{Inf} values.
}
\note{
This function can work with \code{\linkS4class{Risoe.BINfileData}} objects or
\code{\linkS4class{RLum.Analysis}} objects (or a list of it). However, the function is highly optimised
for \code{\linkS4class{Risoe.BINfileData}} objects as it make sense to remove identify invalid
grains before the conversion to an \code{\linkS4class{RLum.Analysis}} object.\cr

The function checking for invalid curves works rather robust and it is likely that Reg0 curves
within a SAR cycle are removed as well. Therefore it is strongly recommended to use the argument
\code{cleanup = TRUE} carefully.
}
\section{Function version}{
 0.1.0 (2016-05-24 12:00:22)
}
\examples{

##01 - basic example I
##just show how to apply the function
data(ExampleData.XSYG, envir = environment())

##verify and get data.frame out of it
verify_SingleGrainData(OSL.SARMeasurement$Sequence.Object)$selection_full

##02 - basic example II
data(ExampleData.BINfileData, envir = environment())
id <- verify_SingleGrainData(object = CWOSL.SAR.Data,
cleanup_level = "aliquot")$selection_id

\dontrun{
##03 - advanced example I
##importing and exporting a BIN-file

##select and import file
file <- file.choose()
object <- read_BIN2R(file)

##remove invalid aliquots(!)
object <- verify_SingleGrainData(object, cleanup = TRUE)

##export to new BIN-file
write_R2BIN(object, paste0(dirname(file),"/", basename(file), "_CLEANED.BIN"))
}

}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
\cr R Luminescence Package Team}
\references{
-
}
\seealso{
\code{\linkS4class{Risoe.BINfileData}}, \code{\linkS4class{RLum.Analysis}},
\code{\link{write_R2BIN}}, \code{\link{read_BIN2R}}
}
\keyword{datagen}
\keyword{manip}

