% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\docType{package}
\name{Luminescence-package}
\alias{Luminescence-package}
\alias{Luminescence}
\title{Comprehensive Luminescence Dating Data Analysis}
\description{
A collection of various R functions for the purpose of Luminescence dating
data analysis. This includes, amongst others, data import, export,
application of age models, curve deconvolution, sequence analysis and
plotting of equivalent dose distributions.
}
\details{
\tabular{ll}{
\strong{Package:} \tab Luminescence \cr
\strong{Type:} \tab Package \cr
\strong{Version:} \tab 0.8.3 \cr
\strong{Date:} \tab 2018-04-20 \cr
\strong{License:} \tab GPL-3 \cr
}
}
\references{
Dietze, M., Kreutzer, S., Fuchs, M.C., Burow, C., Fischer, M.,
Schmidt, C., 2013. A practical guide to the R package Luminescence.
Ancient TL, 31 (1), 11-18.

Dietze, M., Kreutzer, S., Burow, C., Fuchs, M.C., Fischer, M., Schmidt, C., 2016. The abanico plot:
visualising chronometric data with individual standard errors. Quaternary Geochronology 31, 1-7.
http://dx.doi.org/10.1016/j.quageo.2015.09.003

Fuchs, M.C., Kreutzer, S., Burow, C., Dietze, M., Fischer, M., Schmidt, C.,
Fuchs, M., 2015. Data processing in luminescence dating analysis: An
exemplary workflow using the R package 'Luminescence'. Quaternary
International, 362,8-13. http://dx.doi.org/10.1016/j.quaint.2014.06.034

Kreutzer, S., Schmidt, C., Fuchs, M.C., Dietze, M., Fischer, M., Fuchs, M.,
2012. Introducing an R package for luminescence dating analysis. Ancient TL,
30 (1), 1-8.

Mercier, N., Kreutzer, S., Christophe, C., Guérin, G., Guibert, P., Lahaye, C., Lanos, P., Philippe, A.,
Tribolo, C., 2016. Bayesian statistics in luminescence dating: The ’baSAR’-model and its
implementation in the R package ’Luminescence’. Ancient TL 34 (2), 14–21.

Smedley, R.K., 2015. A new R function for the Internal External Uncertainty (IEU) model.
Ancient TL, 33 (1), 16-21.
}
\author{
\strong{Full list of authors and contributors} (alphabetic order)

\tabular{ll}{
Christoph Burow \tab \emph{University of Cologne, Germany}* \cr
Claire Christophe \tab \emph{IRAMAT-CRP2A, Université Bordeaux Montaigne, France} \cr
Michael Dietze \tab \emph{GFZ Helmholtz Centre Potsdam, Germany} \cr
Julie Durcan \tab \emph{University of Oxford, United Kingdom} \cr
Manfred Fischer\tab \emph{University of Bayreuth, Germany} \cr
Margret C. Fuchs \tab \emph{Helmholtz-Zentrum Dresden-Rossendorf, Helmholtz-Institute Freiberg for Resource Technology, Freiberg, Germany} \cr
Johannes Friedrich \tab \emph{University of Bayreuth, Germany} \cr
Guillaume Guérin \tab \emph{IRAMAT-CRP2A, Université Bordeaux Montaigne, France} \cr
Georgina E. King \tab \emph{Institute of Geological Sciences, University of Bern, Switzerland} \cr
Sebastian Kreutzer \tab \emph{IRAMAT-CRP2A, Université Bordeaux Montaigne, France} \cr
Norbert Mercier \tab \emph{IRAMAT-CRP2A, Université Bordeaux Montaigne, France} \cr
Anne Philippe \tab  \emph{Universite de Nantes and ANJA INRIA, Rennes, France} \cr
Christoph Schmidt \tab \emph{University of Bayreuth, Germany} \cr
Rachel K. Smedley \tab \emph{Aberystwyth University, United Kingdom} \cr
Antoine Zink \tab \emph{C2RMF, Palais du Louvre, Paris, France}
}

\strong{Supervisor of the initial version in 2012}

Markus Fuchs, Justus-Liebig-University Giessen, Germany

\strong{Support contact}

\email{developers@r-luminescence.org}

We may further encourage the usage of our support forum. For this please
visit our project website (link below).

\strong{Bug reporting}
\itemize{
\item \email{developers@r-luminescence.org} or
\item \url{https://github.com/R-Lum/Luminescence/issues}
}

\strong{Project website}
\itemize{
\item \url{http://www.r-luminescence.org}
}

\strong{Project source code repository}
\itemize{
\item \url{https://github.com/R-Lum/Luminescence}
}

\strong{Related package projects}
\itemize{
\item \url{https://cran.r-project.org/package=RLumShiny}
\item \url{http://shiny.r-luminescence.org}
\item \url{https://cran.r-project.org/package=RLumModel}
\item \url{http://model.r-luminescence.org}
}

\strong{Package maintainer}

Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne, Pessac, France,\cr
\email{sebastian.kreutzer@u-bordeaux-montaigne.fr}

\strong{Acknowledgement}

Cooperation and personal exchange between the developers is gratefully
funded by the DFG (SCHM 3051/3-1) in the framework of the program
"Scientific Networks". Project title: "RLum.Network: Ein
Wissenschaftsnetzwerk zur Analyse von Lumineszenzdaten mit R" (2014-2018)
}
\keyword{package}
