% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_CWCurve.R
\name{fit_CWCurve}
\alias{fit_CWCurve}
\title{Nonlinear Least Squares Fit for CW-OSL curves -beta version-}
\usage{
fit_CWCurve(
  values,
  n.components.max,
  fit.failure_threshold = 5,
  fit.method = "port",
  fit.trace = FALSE,
  fit.calcError = FALSE,
  LED.power = 36,
  LED.wavelength = 470,
  cex.global = 0.6,
  sample_code = "Default",
  output.path,
  output.terminal = TRUE,
  output.terminalAdvanced = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{values}{\linkS4class{RLum.Data.Curve} or \link{data.frame} (\strong{required}):
x, y data of measured values (time and counts). See examples.}

\item{n.components.max}{\link{vector} (\emph{optional}):
maximum number of components that are to be used for fitting.
The upper limit is 7.}

\item{fit.failure_threshold}{\link{vector} (\emph{with default}):
limits the failed fitting attempts.}

\item{fit.method}{\link{character} (\emph{with default}):
select fit method, allowed values: \code{'port'} and \code{'LM'}. \code{'port'} uses the 'port'
routine from the function \link{nls} \code{'LM'} utilises the function \code{nlsLM} from
the package \code{minpack.lm} and with that the Levenberg-Marquardt algorithm.}

\item{fit.trace}{\link{logical} (\emph{with default}):
traces the fitting process on the terminal.}

\item{fit.calcError}{\link{logical} (\emph{with default}):
calculate 1-sigma error range of components using \link[stats:confint]{stats::confint}}

\item{LED.power}{\link{numeric} (\emph{with default}):
LED power (max.) used for intensity ramping in mW/cm^2.
\strong{Note:} The value is used for the calculation of the absolute
photoionisation cross section.}

\item{LED.wavelength}{\link{numeric} (\emph{with default}):
LED wavelength used for stimulation in nm.
\strong{Note:} The value is used for the calculation of the absolute
photoionisation cross section.}

\item{cex.global}{\link{numeric} (\emph{with default}):
global scaling factor.}

\item{sample_code}{\link{character} (\emph{optional}):
sample code used for the plot and the optional output table (\code{mtext}).}

\item{output.path}{\link{character} (\emph{optional}):
output path for table output containing the results of the fit. The file
name is set automatically. If the file already exists in the directory,
the values are appended.}

\item{output.terminal}{\link{logical} (\emph{with default}):
terminal output with fitting results.}

\item{output.terminalAdvanced}{\link{logical} (\emph{with default}):
enhanced terminal output. Requires \code{output.terminal = TRUE}.
If \code{output.terminal = FALSE} no advanced output is possible.}

\item{plot}{\link{logical} (\emph{with default}):
returns a plot of the fitted curves.}

\item{...}{further arguments and graphical parameters passed to \link{plot}.}
}
\value{
\strong{plot (\emph{optional})}

the fitted CW-OSL curves are returned as plot.

\strong{table (\emph{optional})}

an output table (\verb{*.csv}) with parameters of the fitted components is
provided if the \code{output.path} is set.

\strong{RLum.Results}

Beside the plot and table output options, an \linkS4class{RLum.Results} object is
returned.

\code{fit}:
an \code{nls} object (\verb{$fit}) for which generic R functions are
provided, e.g. \link{summary}, \link[stats:confint]{stats::confint}, \link{profile}. For more
details, see \link{nls}.

\code{output.table}:
a \link{data.frame} containing the summarised parameters including the error

\code{component.contribution.matrix}:
\link{matrix} containing the values for the component to sum contribution plot
(\verb{$component.contribution.matrix}).

Matrix structure:\cr
Column 1 and 2: time and \code{rev(time)} values \cr
Additional columns are used for the components, two for each component,
containing I0 and n0. The last columns \code{cont.} provide information on
the relative component contribution for each time interval including the row
sum for this values.

\strong{object}

beside the plot and table output options, an \linkS4class{RLum.Results} object
is returned.

\code{fit}:
an \code{nls} object (\verb{$fit}) for which generic R functions
are provided, e.g. \link{summary}, \link{confint}, \link{profile}. For more
details, see \link{nls}.

\code{output.table}:
a \link{data.frame} containing the summarised parameters including the error\cr
\code{component.contribution.matrix}: \link{matrix} containing the values
for the component to sum contribution plot (\verb{$component.contribution.matrix}).\cr

Matrix structure:\cr
Column 1 and 2: time and \code{rev(time)} values\cr
Additional columns are used for the components, two for each component,
containing I0 and n0. The last columns \code{cont.} provide information on
the relative component contribution for each time interval including the row
sum for this values.
}
\description{
The function determines the weighted least-squares estimates of the
component parameters of a CW-OSL signal for a given maximum number of
components and returns various component parameters. The fitting procedure
uses the \link{nls} function with the \code{port} algorithm.
}
\details{
\strong{Fitting function}

The function for the CW-OSL fitting has the general form:

\deqn{y = I0_{1}*\lambda_{1}*exp(-\lambda_1*x) + ,\ldots, + I0_{i}*\lambda_{i}*exp(-\lambda_i*x) }

where \eqn{0 < i < 8}

and \eqn{\lambda} is the decay constant \cr
and \eqn{I0} the initial number of trapped electrons.

\emph{(for the used equation cf. Boetter-Jensen et al., 2003, Eq. 2.31)}

\strong{Start values}

Start values are estimated automatically by fitting a linear function to the
logarithmized input data set. Currently, there is no option to manually
provide start parameters.

\strong{Goodness of fit}

The goodness of the fit is given as pseudoR^2 value (pseudo coefficient of
determination). According to Lave (1970), the value is calculated as:

\deqn{pseudoR^2 = 1 - RSS/TSS}

where \eqn{RSS = Residual~Sum~of~Squares} \cr
and \eqn{TSS = Total~Sum~of~Squares}

\strong{Error of fitted component parameters}

The 1-sigma error for the
components is calculated using the function \link[stats:confint]{stats::confint}. Due to
considerable calculation time, this option is deactivated by default. In
addition, the error for the components can be estimated by using internal R
functions like \link{summary}. See the \link{nls} help page
for more information.

\emph{For details on the nonlinear regression in R, see Ritz & Streibig (2008).}
}
\note{
\strong{Beta version - This function has not been properly tested yet and}
\strong{should therefore not be used for publication purposes!}

The pseudo-R^2 may not be the best parameter to describe the goodness of the
fit. The trade off between the \code{n.components} and the pseudo-R^2 value
is currently not considered.

The function \strong{does not} ensure that the fitting procedure has reached a
global minimum rather than a local minimum!
}
\section{Function version}{
 0.5.2
}

\examples{

##load data
data(ExampleData.CW_OSL_Curve, envir = environment())

##fit data
fit <- fit_CWCurve(values = ExampleData.CW_OSL_Curve,
                   main = "CW Curve Fit",
                   n.components.max = 4,
                   log = "x")

} 

\section{How to cite}{
Kreutzer, S., 2022. fit_CWCurve(): Nonlinear Least Squares Fit for CW-OSL curves -beta version-. Function version 0.5.2. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2022. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.17. https://CRAN.R-project.org/package=Luminescence
}

\references{
Boetter-Jensen, L., McKeever, S.W.S., Wintle, A.G., 2003.
Optically Stimulated Luminescence Dosimetry. Elsevier Science B.V.

Lave, C.A.T., 1970. The Demand for Urban Mass Transportation. The Review of
Economics and Statistics, 52 (3), 320-323.

Ritz, C. & Streibig, J.C., 2008. Nonlinear Regression with R. In: R.
Gentleman, K. Hornik, G. Parmigiani, eds., Springer, p. 150.
}
\seealso{
\link{fit_LMCurve}, \link{plot},\link{nls}, \linkS4class{RLum.Data.Curve},
\linkS4class{RLum.Results}, \link{get_RLum}, \link[minpack.lm:nlsLM]{minpack.lm::nlsLM}
}
\author{
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team}
\keyword{dplot}
\keyword{models}
