% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_EED_Model.R
\name{calc_EED_Model}
\alias{calc_EED_Model}
\title{Modelling Exponential Exposure Distribution}
\usage{
calc_EED_Model(
  data,
  D0 = 120L,
  expected_dose,
  MinIndivDose = NULL,
  MaxIndivDose = NULL,
  kappa = NULL,
  sigma_distr = NULL,
  n.simul = 5000L,
  n.minSimExp = 50L,
  sample_name = "",
  method_control = list(),
  verbose = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{data}{\link{data.frame} (\strong{required}): input data consisting of two columns, the De and the
SE(De). Values are expected in Gy}

\item{D0}{\link{integer} (\emph{with default}): D0 value (in Gy), defining the
characterisation behaviour of the quartz.}

\item{expected_dose}{\link{numeric} (\strong{required}): expected equivalent dose}

\item{MinIndivDose}{\link{numeric} (\emph{with default}): value specifying the minimum dose taken into
account for the plateau. \code{NULL} applies all values.}

\item{MaxIndivDose}{\link{numeric} (\emph{with default}): value specifying the maximum dose taken into
account for the plateau. \code{NULL} applies all values.}

\item{kappa}{\link{numeric} (\emph{optional}): positive dimensionless exposure parameter
characterising the bleaching state of the grains. Low values (< 10) indicate
poor bleaching}

\item{sigma_distr}{\link{numeric} (\emph{optional}): positive dose rate parameter, representing the
dose variability to which the grains were exposed ##TODO perhaps it should be renamed}

\item{n.simul}{\link{integer} (\emph{with default}): number of simulations}

\item{n.minSimExp}{\link{integer} (\emph{with default}): number of MC runs for calculating the uncertainty
contribution from the sampling}

\item{sample_name}{\link{character} (\emph{with default}): name of the sample}

\item{method_control}{\link{list} (\emph{with default}): additional deep control parameters, parameters
need to be provided as named list, see details}

\item{verbose}{\link{logical} (\emph{with default}): enable/disable output to the
terminal.}

\item{plot}{\link{logical} (\emph{with default}): enable/disable the plot output.}

\item{...}{further parameters that can be passed to better control the plot output. Support arguments
are \code{xlab}, \code{xlim}.}
}
\description{
Modelling incomplete and heterogeneous bleaching of mobile grains partially
exposed to the light, an implementation of the EED model proposed by Guibert et al. (2019).
}
\details{
The function is an implementation and enhancement of the scripts used in
Guibert et al. (2019). The implementation supports a semi-automated estimation
of the parameters \code{kappa} and \code{sigma_distr}. If set to \code{NULL}, a surface interpolation
is used to estimated those values.

\strong{Method control parameters}

\tabular{llll}{
\strong{ARGUMENT} \tab \strong{FUNCTION} \tab \strong{DEFAULT} \tab \strong{DESCRIPTION}\cr
\code{lower}  \tab  - \tab \code{c(0.1,0,0)} \tab set lower bounds for kappa, sigma, and the expected De in auto mode \cr
\code{upper} \tab  - \tab \code{c(1000,2)} \tab set upper bounds for kappa, sigma, and the expected De in auto mode \cr
\code{iter_max} \tab - \tab \code{1000} \tab maximum number for iterations for used to find kappa and sigma \cr
\code{trace} \tab - \tab \code{FALSE} \tab enable/disable terminal trace mode; overwritten by global argument \code{verbose}\cr
\code{trace_plot} \tab - \tab \code{FALSE} \tab enable/disable additional trace plot output; overwritten by global argument \code{verbose} \cr

}
}
\section{Function version}{
 0.1.0
}

\examples{

data(ExampleData.MortarData, envir = environment())
calc_EED_Model(
 data = MortarData,
 kappa = 14,
 sigma_distr = 0.37,
 expected_dose = 11.7)

## automated estimation of
## sigma_distribution and
## kappa
\dontrun{
 calc_EED_Model(
 data = MortarData,
 kappa = NULL,
 sigma_distr = NULL,
 expected_dose = 11.7)
}

} 

\section{How to cite}{
Guibert, P., Kreutzer, S., 2025. calc_EED_Model(): Modelling Exponential Exposure Distribution. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.0.0. https://r-lum.github.io/Luminescence/
}

\references{
Guibert, P., Christophe, C., Urbanova, P., Guérin, G., Blain, S., 2017.
Modelling incomplete and heterogeneous bleaching of mobile grains partially exposed to the
light - Towards a new tool for single grain OSL dating of poorly bleached mortars.
Radiation Measurements 107, 48–57. \doi{10.1016/j.radmeas.2017.10.003}
}
\seealso{
\linkS4class{RLum.Results}, \link{calc_MinDose}, \link{calc_FuchsLang2001}, \link{calc_IEU},
\link{calc_FiniteMixture}
}
\author{
Pierre Guibert, IRAMAT-CRP2A, UMR 5060, Université Bordeaux Montaigne (France),
Sebastian Kreutzer, Geography & Earth Sciences, Aberystwyth University (United Kingdom)
, RLum Developer Team}
\keyword{datagen}
