/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1;

import com.sosnoski.util.hashset.IntHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.graph.Directedness;
import uk.ac.rhul.cs.graph.Edge;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.stats.independentsamples.MannWhitneyTest;
import uk.ac.rhul.cs.stats.tests.H1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutableNodeSet
extends NodeSet {
    protected IntHashSet memberHashSet = new IntHashSet();
    protected double[] inWeights = null;
    protected double[] outWeights = null;

    public MutableNodeSet(Graph graph) {
        super(graph);
        this.members = new TreeSet();
        this.initializeInOutWeights();
    }

    public MutableNodeSet(Graph graph, Collection<Integer> members) {
        this(graph);
        this.setMembers(members);
    }

    public MutableNodeSet(Graph graph, int[] members) {
        this(graph);
        this.setMembers(members);
    }

    public MutableNodeSet(NodeSet nodeSet) {
        this(nodeSet.getGraph(), nodeSet.getMembers());
    }

    protected void initializeInOutWeights() {
        this.totalInternalEdgeWeight = 0.0;
        this.totalBoundaryEdgeWeight = 0.0;
        if (this.inWeights == null) {
            this.inWeights = new double[this.graph.getNodeCount()];
        }
        if (this.outWeights == null) {
            this.outWeights = new double[this.graph.getNodeCount()];
        }
        Arrays.fill(this.inWeights, 0.0);
        Arrays.fill(this.outWeights, 0.0);
        for (Edge e : this.graph) {
            int n = e.source;
            this.outWeights[n] = this.outWeights[n] + e.weight;
            int n2 = e.target;
            this.outWeights[n2] = this.outWeights[n2] + e.weight;
        }
    }

    public boolean add(int node) {
        if (this.memberHashSet.contains(node)) {
            return false;
        }
        this.invalidateCache();
        this.totalInternalEdgeWeight += this.inWeights[node];
        this.totalBoundaryEdgeWeight += this.outWeights[node] - this.inWeights[node];
        for (int adjEdge : this.graph.getAdjacentEdgeIndicesArray(node, Directedness.ALL)) {
            int adjNode = this.graph.getEdgeEndpoint(adjEdge, node);
            if (adjNode == node) continue;
            double weight = this.graph.getEdgeWeight(adjEdge);
            int n = adjNode;
            this.inWeights[n] = this.inWeights[n] + weight;
            int n2 = adjNode;
            this.outWeights[n2] = this.outWeights[n2] - weight;
        }
        this.memberHashSet.add(node);
        this.members.add(node);
        return true;
    }

    public int add(int[] nodes) {
        int result = 0;
        for (int i : nodes) {
            if (!this.add(i)) continue;
            ++result;
        }
        return result;
    }

    public void clear() {
        this.invalidateCache();
        this.members.clear();
        this.memberHashSet.clear();
        this.initializeInOutWeights();
    }

    public NodeSet freeze() {
        NodeSet result = new NodeSet(this.graph);
        result.members = this.members;
        result.totalInternalEdgeWeight = this.totalInternalEdgeWeight;
        result.totalBoundaryEdgeWeight = this.totalBoundaryEdgeWeight;
        return result;
    }

    @Override
    public double getCommitment(int nodeIndex) {
        double den = this.inWeights[nodeIndex] + this.outWeights[nodeIndex];
        if (den == 0.0) {
            return 0.0;
        }
        return this.inWeights[nodeIndex] / den;
    }

    @Override
    public double getInternalWeight(int nodeIndex) {
        return this.inWeights[nodeIndex];
    }

    public double getTotalAdjacentInternalWeight(int nodeIndex) {
        return this.inWeights[nodeIndex];
    }

    @Override
    protected IntHashSet getMemberHashSet() {
        return this.memberHashSet;
    }

    @Override
    protected double getSignificanceReal() {
        MannWhitneyTest test = new MannWhitneyTest(this.inWeights, this.outWeights, H1.GREATER_THAN);
        return test.getSP();
    }

    private void invalidateCache() {
    }

    public boolean remove(int node) {
        if (!this.memberHashSet.contains(node)) {
            return false;
        }
        this.invalidateCache();
        this.totalInternalEdgeWeight -= this.inWeights[node];
        this.totalBoundaryEdgeWeight -= this.outWeights[node] - this.inWeights[node];
        for (int adjEdge : this.graph.getAdjacentEdgeIndicesArray(node, Directedness.ALL)) {
            int adjNode = this.graph.getEdgeEndpoint(adjEdge, node);
            if (adjNode == node) continue;
            double weight = this.graph.getEdgeWeight(adjEdge);
            int n = adjNode;
            this.inWeights[n] = this.inWeights[n] - weight;
            int n2 = adjNode;
            this.outWeights[n2] = this.outWeights[n2] + weight;
        }
        this.memberHashSet.remove(node);
        this.members.remove(node);
        return true;
    }

    public void remove(int[] nodes) {
        for (int i : nodes) {
            this.remove(i);
        }
    }

    @Override
    protected void setMembers(int[] members) {
        this.clear();
        for (int member : members) {
            this.add(member);
        }
    }

    @Override
    public void setMembers(Iterable<Integer> members) {
        this.clear();
        for (int member : members) {
            this.add(member);
        }
    }
}

