/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape3;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import uk.ac.rhul.cs.cl1.ui.cytoscape3.CyNodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph
extends uk.ac.rhul.cs.graph.Graph {
    protected CyNetwork network;
    protected List<CyNode> nodeMapping = new ArrayList<CyNode>();

    public Graph(CyNetwork network) {
        this.setCyNetwork(network);
    }

    public Graph(boolean directed) {
        super(directed);
    }

    public List<CyNode> getNodeMapping() {
        return this.nodeMapping;
    }

    public CyNetwork getCyNetwork() {
        return this.network;
    }

    public void setCyNetwork(CyNetwork network) {
        this.network = network;
    }

    public void setNodeMapping(List<CyNode> nodeMapping) {
        if (nodeMapping.size() != this.getNodeCount()) {
            throw new ArrayIndexOutOfBoundsException("node mapping list must be of length " + this.getNodeCount());
        }
        this.nodeMapping = nodeMapping;
    }

    @Override
    public String getNodeName(int index) {
        CyNode node = this.nodeMapping.get(index);
        return CyNodeUtil.getName(this.network, node, "");
    }

    public List<Integer> getMappedNodeIndices(Collection<CyNode> nodes) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (CyNode node : nodes) {
            int index = this.nodeMapping.indexOf(node);
            if (index < 0) continue;
            result.add(index);
        }
        return result;
    }
}

