% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichmentCPX.R
\name{enrichmentCPX}
\alias{enrichmentCPX}
\title{Functional Enrichment Analysis for Predicted Complexes}
\usage{
enrichmentCPX(
  predcpx,
  threshold = 0.05,
  sources = c("GO", "KEGG", "CORUM", "REAC", "CORUM"),
  p.corrction.method = "bonferroni",
  custom_bg = NULL,
  org = "mmusculus"
)
}
\arguments{
\item{predcpx}{A data.frame containing predicted complexes resulted from
\code{\link[MACP]{get_clusters}} or \code{\link[MACP]{MCL_clustering}}.}

\item{threshold}{Custom p-value threshold for significance.}

\item{sources}{A vector of data sources to use.
See \code{\link[gprofiler2]{gost}} for more details.}

\item{p.corrction.method}{The algorithm used for multiple testing
correction;defaults to 'bonferroni'.
See \code{\link[gprofiler2]{gost}} for more details.}

\item{custom_bg}{vector of gene names to use as a statistical background.
Defaults to NULL.}

\item{org}{An organism name;defaults to 'mmusculus'.
See \code{\link[gprofiler2]{gost}} for more details.}
}
\value{
A data.frame with the enrichment analysis results.
}
\description{
This function uses \code{\link[gprofiler2]{gost}} function
in \code{gprofiler2} package to perform functional enrichment analysis
for predicted modules.
}
\details{
enrichmentCPX
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
