% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractIntensity.R
\name{extractIntensity}
\alias{extractIntensity}
\title{Extract intensity using peaks as template}
\usage{
extractIntensity(mz, peaks, spec, tol)
}
\arguments{
\item{mz}{numeric, mz values to be extracted from the peaks/spectra}

\item{peaks}{MALDIquant::MassPeaks list}

\item{spec}{MALDIquant::MassSpectrum list}

\item{tol}{numeric, tolerance in Da}
}
\value{
MALDIquant::MassPeaks list with extracted intensities from spec at m/z of peaks = pseudo peaks.
Useful in combination with sdMassSpectrum to get standard deviation of peaks as intensity matrix.
}
\description{
Extract intensity using peaks as template
}
\examples{
data(Blank2022peaks)
data(Blank2022spec)

int <- extractIntensity(mz = c(409, 423, 440), 
                        peaks = Blank2022peaks, 
                        spec = Blank2022spec, 
                        tol = 0.2)
head(int)
}
