\name{plot.scSpectra}
\alias{plot.scSpectra}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Graphical summary of \code{screenSpectra} objects
}
\description{
This is a \code{plot} method for \code{scSpectra} objects that displays the results from applying \code{screenSpectra} to identify potential faulty, low-quality raw mass spectra.
}
\usage{
\method{plot}{scSpectra}(x, type = c("index", "hist", "casewise"), breaks = 30,
        labels = FALSE, col = "green3", ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
A \code{scSpectra} object as generated by \code{\link{screenSpectra}}.
}
  \item{type}{
Type of graphical display.
}
  \item{breaks}{
Number of break points for plotting a histogram when \code{type = "hist"} (default = 30).
}
  \item{labels}{
Vector of labels for the mass spectra (default = \code{FALSE}, no labels).
}
  \item{col}{
Colour for the histogram bars when \code{type = "hist"}.
}
  \item{...}{
Other arguments.
}
}
\details{
For \code{type = "index"} (default) the upper and lower fences used to declare a mass spectrum as potentially low-quality are shown along with their A scores (see \code{\link{screenSpectra}} for details). Point labels can be added using the \code{labels} argument (either a position index when \code{labels = TRUE} or a given vector of labels; see examples below). For \code{type = "hist"} a histogram of the distribution of the A scores is produced along with the tolerance fences. Finally, \code{type = "casewise"} displays interactively the flagged spectra for visual inspection.
}

\seealso{
See \code{\link{screenSpectra}} and \code{\link{summary.scSpectra}}.
}

\examples{
# Load example data

data(spectra) # list of MassSpectra objects
data(type)    # metadata

sc.results <- screenSpectra(spectra)
plot(sc.results)
plot(sc.results, labels = TRUE)
plot(sc.results, labels = type$SpectID)
plot(sc.results, type = "hist")
}
