% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_03_1_CompareValues_PSI.R
\name{CompareValues.PSI}
\alias{CompareValues.PSI}
\title{Differential splicing analysis}
\usage{
CompareValues.PSI(MarvelObject, cell.types, n.cells, method, method.adjust)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{ComputePSI} function.}

\item{cell.types}{Character string. To indicate which 2 groups of cells that will be used for differential splicing analysis. Group names should match those in \code{cell.type} column of \code{$SplicePheno} slot.}

\item{n.cells}{Numeric value. The minimum no. of cells expressing the splicing event for the event to be included for differential splicing analysis.}

\item{method}{Character string. Statistical test to compare the 2 groups of cells. \code{"ks"}, \code{"wilcox"}, and \code{"t.test"} for Kolmogorov-Smirnov, Wilcox, and t-test, respectively. We advice \code{"ks"} for PSI comparison while \code{"wilcox"} or \code{"t.test"} for gene expression comparison.}

\item{method.adjust}{Character string. Adjust p-values for multiple testing. Options available as per \code{p.adjust} function.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{$DE$PSI}
}
\description{
\code{CompareValues.PSI} performs differentially splicing analysis between 2 groups of cells.
}
\details{
This function compares the percent spliced-in (PSI) values between 2 groups of cells.
}
\examples{
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

marvel <- CompareValues.PSI(MarvelObject=marvel,
                            cell.types=c("iPSC", "Endoderm"),
                            n.cells=25,
                            method="t.test",
                            method.adjust="fdr"
                            )

marvel$DE$PSI[1:5, ]
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
