% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_06_DE_2_3_PlotDEValues_Exp_Mean.R
\name{PlotDEValues.Exp}
\alias{PlotDEValues.Exp}
\title{Plot Differential Gene Expression Analysis Results}
\usage{
PlotDEValues.Exp(
  MarvelObject,
  de.p.val.adj,
  log2fc,
  anno = FALSE,
  anno.x.pos = NULL,
  anno.y.pos = NULL,
  anno.x.neg = NULL,
  anno.y.neg = NULL,
  label.size = 2.5
)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CompareValues} function.}

\item{de.p.val.adj}{Numeric value. Adjusted p-value below which the genes are considered as statistically significant and will consequently be color-annotated on the plot.}

\item{log2fc}{Numeric value. The positive (and negative) value specified above (and below) which the genes are considered to be statistically significant and will consequently be color-annotated on the plot.}

\item{anno}{Logical value. If set to \code{TRUE}, the specific gene names will be annotated on the plot. Speficified together with \code{anno.x.pos}, \code{anno.y.pos}, \code{anno.x.neg}, and \code{anno.y.neg}.}

\item{anno.x.pos}{Numeric value. The value above on the x-axis which the gene names will be annotated on the plot. Specified together with \code{anno.y.pos}, \code{anno.x.neg}, and \code{anno.y.neg}.}

\item{anno.y.pos}{Numeric value. The value above on the y-axis which the gene names will be annotated on the plot. Specified together with \code{anno.x.pos}, \code{anno.x.neg}, and \code{anno.y.neg}.}

\item{anno.x.neg}{Numeric value. The value below on the x-axis which the gene names will be annotated on the plot. Specified together with \code{anno.x.pos}, \code{anno.y.pos}, and \code{anno.y.neg}.}

\item{anno.y.neg}{Numeric value. The value above on the y-axis which the gene names will be annotated on the plot. Specified together with \code{anno.y.pos}, \code{anno.x.neg}, and \code{anno.x.pos}.}

\item{label.size}{Numeric value. Only applicable if \code{anno} set to TRUE. Size of the gene name labels.}
}
\value{
An object of class S3 containing all the original slots as inputted by the user in addition to one new slot named \code{MarvelObject$DE$Exp$Plot}.
}
\description{
\code{PlotDEValues.Exp} plots the differential gene expression analysis results.
}
\details{
This function plot the differential gene expression analysis results and can annotate the user-defined significant data points and gene names.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- PlotDEValues.Exp(MarvelObject=marvel,
                           de.p.val.adj=0.10,
                           log2fc=0.5,
                           anno=FALSE
                          )

# Check output
marvel$DE$Exp$Plot
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
