% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.functions.R
\name{mbnma.update}
\alias{mbnma.update}
\title{Update MBNMA to monitor deviance nodes in the model}
\usage{
mbnma.update(
  mbnma,
  param = "theta",
  n.iter = mbnma$BUGSoutput$n.iter,
  n.thin = mbnma$BUGSoutput$n.thin
)
}
\arguments{
\item{mbnma}{An S3 object of class \code{"mbnma"} generated by running
a dose-response MBNMA model}

\item{param}{Used to indicate which node to monitor in the model. Can be any parameter
in the model code that varies by all arms within all studies. These are some typical
parameters that it might be of interest to monitor, provided they are in the original
model code:
\itemize{
\item \code{"theta"} for fitted values
\item \code{"psi"} for fitted values on natural scale (e.g. probabilities)
\item \code{"dev"} for deviance contributions
\item \code{"resdev"} for residual deviance contributions
\item \code{"delta"} for within-study relative effects versus the study reference treatment
}}

\item{n.iter}{number of total iterations per chain (including burn in;
    default: 2000)}

\item{n.thin}{thinning rate. Must be a positive integer.  Set
    \code{n.thin} > 1 to save memory and computation time if
    \code{n.iter} is large.  Default is \code{max(1, floor(n.chains *
    (n.iter-n.burnin) / 1000))} which will only thin if there are at
    least 2000 simulations.}
}
\value{
A data frame containing the posterior mean of the updates by arm and study,
with arm and study identifiers.

For MBNMAdose:
\itemize{
\item \code{facet} indicates the agent identifier in the given arm of a study
\item \code{fupdose} indicates the dose in the given arm of a study
}

For MBNMAtime:
\itemize{
\item \code{facet} indicates the treatment identifier in the given arm of the study
\item \code{fupdose} indicates the follow-up time at the given observation in the given
arm of the study
}
}
\description{
Useful for obtaining deviance contributions or fitted values
}
\examples{
\donttest{
# Using the triptans data
network <- mbnma.network(HF2PPITT)

# Fit a dose-response MBNMA, monitoring "psi" and "resdev"
result <- mbnma.run(network, fun="exponential", beta.1="rel", method="random",
  parameters.to.save=c("psi", "resdev"))

mbnma.update(result, param="theta") # monitor theta

mbnma.update(result, param="rhat") # monitor rhat

mbnma.update(result, param="delta") # monitor delta
}

}
