% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma-class.R, R/run.functions.R
\name{plot.nma}
\alias{plot.nma}
\alias{nma.run}
\title{Run an NMA model}
\usage{
\method{plot}{nma}(x, bydose = TRUE, scales = "free_x", ...)

nma.run(
  network,
  method = "common",
  likelihood = NULL,
  link = NULL,
  priors = NULL,
  warn.rhat = TRUE,
  n.iter = 10000,
  drop.discon = TRUE,
  UME = FALSE,
  pd = "pv",
  ...
)
}
\arguments{
\item{x}{An object of \code{class("nma")}}

\item{bydose}{A boolean object indicating whether to plot responses with dose
on the x-axis (\code{TRUE}) to be able to examine potential dose-response shapes, or
to plot a conventional forest plot with all treatments on the same plot (\code{FALSE})}

\item{scales}{Should scales be fixed (\code{"fixed"}, the default),
free (\code{"free"}), or free in one dimension (\code{"free_x"},
\code{"free_y"})?}

\item{...}{Arguments to be sent to \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}}

\item{network}{An object of class \code{mbnma.network}.}

\item{method}{Indicates the type of split (treatment-level) NMA to perform when \code{overlay.split=TRUE}. Can
take either \code{"common"} or \code{"random"}.}

\item{likelihood}{A string indicating the likelihood to use in the model. Can take either \code{"binomial"},
\code{"normal"} or \code{"poisson"}. If left as \code{NULL} the likelihood will be inferred from the data.}

\item{link}{A string indicating the link function to use in the model. Can take any link function
defined within JAGS (e.g. \code{"logit"}, \code{"log"}, \code{"probit"}, \code{"cloglog"}) or be assigned the value \code{"identity"} for
and identity link function. If left as \code{NULL} the link function will be automatically assigned based
on the likelihood.}

\item{priors}{A named list of parameter values (without indices) and
replacement prior distribution values given as strings
\strong{using distributions as specified in JAGS syntax} (see examples).}

\item{warn.rhat}{A boolean object to indicate whether to return a warning if Rhat values
for any monitored parameter are >1.02 (suggestive of non-convergence).}

\item{n.iter}{number of total iterations per chain (including burn in; default: 10000)}

\item{drop.discon}{A boolean object that indicates whether or not to drop disconnected
studies from the network.}

\item{UME}{A boolean object to indicate whether to fit an Unrelated Mean Effects model
that does not assume consistency and so can be used to test if the consistency
assumption is valid.}

\item{pd}{Can take either:
\itemize{
\item \code{pv} only pV will be reported (as automatically outputted by \code{R2jags}).
\item \code{plugin} calculates pD by the plug-in
method \insertCite{spiegelhalter2002}{MBNMAdose}. It is faster, but may output negative
non-sensical values, due to skewed deviances that can arise with non-linear models.
\item \code{pd.kl} calculates pD by the Kullback-Leibler divergence \insertCite{plummer2008}{MBNMAdose}. This
will require running the model for additional iterations but
will always produce a positive result.
\item \code{popt} calculates pD using an optimism adjustment which allows for calculation
of the penalized expected deviance \insertCite{plummer2008}{MBNMAdose}
}}
}
\description{
Used for calculating split NMA results, either when comparing models that do not
account for dose-response relationship, or to estimate split results for \code{overlay.split}.
Results can also be compared between consistency (\code{UME=FALSE}) and inconsistency
(\code{UME=TRUE}) models to test the validity of the consistency assumption.
}
\section{Methods (by generic)}{
\itemize{
\item \code{plot}: Plot outputs from treatment-level NMA models

Results can be plotted either as a single forest plot, or facetted by agent
and plotted with increasing dose in order to identify potential dose-response
relationships.
}}

\examples{
\donttest{
# Run random effects NMA on the alogliptin dataset
network <- mbnma.network(alog_pcfb)
nma <- nma.run(network, method="random")
print(nma)
plot(nma)

# Run common effects NMA keeping treatments that are disconnected in the NMA
network <- mbnma.network(GoutSUA_2wkCFB)
nma <- nma.run(network, method="common", drop.discon=FALSE)

# Run an Unrelated Mean Effects (UME) inconsistency model on triptans dataset
network <- mbnma.network(HF2PPITT)
ume <- nma.run(network, method="random", UME=TRUE)
}

}
