% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/generate_contin_table_with_clustered_AE_with_tol.R.R
\name{generate_contin_table_with_clustered_AE_with_tol}
\alias{generate_contin_table_with_clustered_AE_with_tol}
\title{Generate simulated contingency tables with the option of incorporating
adverse event correlation within clusters and tolerance for total report
count.}
\usage{
generate_contin_table_with_clustered_AE_with_tol(
  row_marginal,
  column_marginal,
  signal_mat,
  tol = 0.1,
  contin_table = NULL,
  AE_idx = NULL,
  n_rep = 1,
  rho = NULL
)
}
\arguments{
\item{row_marginal}{Marginal sums for the rows of the contingency table.}

\item{column_marginal}{Marginal sums for the columns of the contingency
table.}

\item{signal_mat}{A data matrix of the same dimension as the contingency
table with entries representing the signal strength. The values should
be greater or equal to 1, where 1 indicates no signal, and values
greater than 1 indicate signal.}

\item{tol}{Tolerance for the total report count, expressed in
terms of the Relative Total Difference (RTD), defined as:

\deqn{RTD = \frac{|n^{orig}_{\cdot \cdot} -
n^{sim}_{\cdot \cdot}|}{n^{orig}_{\cdot \cdot}} \times 100}

This represents the difference between the total number of reports in the
simulated datasets and the original input total number of reports.
Sufficiently low tolerance will generate tables with total report counts
equal to the actual supplied value. Default is 0.1.}

\item{contin_table}{A data matrix of an \eqn{I} x \eqn{J} contingency
table with row (adverse event) and column (drug or vaccine) names,
of which the row and column marginals are used to generate the simulated
data. Please first check the input contingency table using the function
\code{check_and_fix_contin_table()}. Default is NULL.}

\item{AE_idx}{A data frame or list.
In case of data frame it must contain two variables \code{idx} and \code{AE},
where \code{idx} indicates the cluster index (a number),
and \code{AE} lists the adverse event names. See the
\code{statin49_AE_idx} for \code{statin49} data as an example.
In case of a list, make sure the cluster indices are aligned with the
corresponding row marginal.}

\item{n_rep}{Number of contingency tables to be generated.}

\item{rho}{A numeric value, matrix, or NULL indicating the correlation
structure.If a numeric value (float or int) is provided, it represents the
correlation value \code{rho} to be used between all elements within each
cluster specified by \code{AE_idx}. If a matrix is provided, it must be a
square matrix with dimensions equal to the number of rows in
\code{contin_table}. In this case, \code{rho} defines the correlation
structure directly, and \code{AE_idx} is not used. If \code{rho} is NULL,
a covariance matrix is generated based on the correlation coefficients of
\code{contin_table}.}
}
\value{
A list of \code{n_rep} simulated contingency tables.
}
\description{
Generate simulated contingency tables with the option of
incorporating adverse event correlation within clusters and tolerance
for total report count.
}
\examples{
# using statin49 as an example
data(statin49)
data(statin49_AE_idx)

# Prepare a matrix of signal strength with the same dimension as
# statin49, where 1 indicates no signal and values > 1 indicate
# signal
lambda_matrix <- matrix(1, nrow = nrow(statin49), ncol = ncol(statin49))
lambda_matrix[1, 1] <- 4

# Generate 5 simulated tables
simulated_tables <- generate_contin_table_with_clustered_AE_with_tol(
  contin_table = statin49,
  signal_mat = lambda_matrix,
  n_rep = 5,
  AE_idx = statin49_AE_idx,
  rho = 0.5,
  tol = 0.1
)
}
