% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-MEDEA.R
\name{cubeMEDEA}
\alias{cubeMEDEA}
\title{Inheritance Cube: MEDEA (Maternal Effect Dominant Embryonic Arrest)}
\usage{
cubeMEDEA(rM = 0, rW = 0, Teff = 1, eta = NULL, phi = NULL,
  omega = NULL, xiF = NULL, xiM = NULL, s = NULL)
}
\arguments{
\item{rM}{Breakdown of MEDEA allele, no homing/toxin/antidote, M -> R conversion}

\item{rW}{De novo resistance generation, W -> R conversion}

\item{Teff}{Efficacy of the toxin}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates an inheritance cube to model a MEDEA drive system. This
system was first discovered in flour beetles. It biases inheritance by expressing
a maternal toxin such that offspring die unless they express a zygotic antidote. \cr
This drive has 3 alleles at 1 locus:
\itemize{
\item W: Wild-type allele
\item M: MEDEA allele
\item R: Resistance allele
}
}
