% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HpltFind_func_20200915.R
\name{HpltFind}
\alias{HpltFind}
\title{HpltFind() function}
\usage{
HpltFind(nest_table, seq_table, path_out)
}
\arguments{
\item{nest_table}{is a table containing the sample names of parents and
offspring in each nest. This table should be organized so that the
individual names are in the first column (Sample_ID), and the nest number
is in the second column (Nest). For each nest, the first two rows should be
the parents, followed immediately by the offspring in the subsequent rows,
and then followed by the next nest, and so on. It is assumed that nests are
numbered consecutively beginning at 1.}

\item{seq_table}{seq_table is a sequence table as output by the 'dada2'
pipeline, which has samples in rows and nucleotide sequence variants in
columns.}

\item{path_out}{is a user defined path to the folder where the output files
will be saved.}
}
\value{
A set of R lists containing for each nest the putative haplotypes,
  the names of sequences that could not be resolved with certainty in each
  parent, the names of the sequences that were incongruent in the genotypes
  of the nest, and the mean proportion of incongruent sequences (which is a
  measure of the haplotype inference success and largely influenced by the
  exactness of the genotyping experiment). The sequences are named in the
  output by an index number corresponding to their column number in the
  sequence table, thus identical sequences will have identical sample names
  in all the output files. These files can be reopened in R e.g. using the
  readRDS() function in the base package.
}
\description{
\code{\link{HpltFind}} is designed to automatically infer major
histocompatibility complex (MHC) haplotypes from the genotypes of parents and
offspring in families (defined as nests) in non-model species, where MHC
sequence variants cannot be identified as belonging to individual loci. The
functions GetHpltTable() and GetHpltStats() are designed to evaluate the
output files.
}
\details{
If you publish data or results produced with MHCtools, please cite both of
the following references:
Roved, J. 2022. MHCtools: Analysis of MHC data in non-model species. Cran.
Roved, J., Hansson, B., Stervander, M., Hasselquist, D., & Westerdahl, H. 2022.
MHCtools – an R package for MHC high‐throughput sequencing data: genotyping,
haplotype and supertype inference, and downstream genetic analyses in non‐model
organisms. Molecular Ecology Resources. https://doi.org/10.1111/1755-0998.13645
}
\examples{
nest_table <- nest_table
seq_table <- sequence_table
path_out <- tempdir()
HpltFind(nest_table, seq_table, path_out)
}
\seealso{
\code{\link{GetHpltTable}}; \code{\link{GetHpltStats}}; for more
  information about 'dada2' visit <https://benjjneb.github.io/dada2/>
}
